/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.protocol.vfsmemory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.memory.MemoryContext;
import org.jboss.virtual.plugins.context.memory.MemoryContextFactory;
import org.jboss.virtual.plugins.vfs.VirtualFileURLConnection;

public class Handler
extends URLStreamHandler {
    protected URLConnection openConnection(URL u) throws IOException {
        String host = u.getHost();
        MemoryContext ctx = MemoryContextFactory.getInstance().find(host);
        if (ctx == null) {
            throw new IOException("vfs does not exist: " + u.toString());
        }
        VirtualFile vf = ctx.getChild(ctx.getRoot(), u.getPath()).getVirtualFile();
        if (vf == null) {
            throw new IOException("vfs does not exist: " + u.toString());
        }
        return new VirtualFileURLConnection(u, vf);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("java.protocol.handler.pkgs", "org.jboss.virtual.protocol");
        URL rootURL = new URL("vfsmemory://aopdomain2");
        MemoryContextFactory.getInstance().createRoot(rootURL);
        URL url = new URL("vfsmemory://aopdomain2/org/foo/Test.class");
        MemoryContextFactory.getInstance().putFile(url, new byte[]{97, 98, 99});
        URL url2 = new URL("vfsmemory://aopdomain2/org/bar/Test.class");
        MemoryContextFactory.getInstance().putFile(url2, new byte[]{100, 101, 102});
        System.out.println("---------");
        InputStream is = url.openStream();
        while (is.available() != 0) {
            System.out.print((char)is.read());
        }
        is.close();
        System.out.println("---------");
        MemoryContextFactory.getInstance().createRoot(rootURL);
        InputStream is2 = url2.openStream();
        while (is2.available() != 0) {
            System.out.print((char)is2.read());
        }
        is.close();
    }
}

