/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.vfs.Assembled;
import org.jboss.virtual.plugins.context.vfs.AssembledContext;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;
import org.jboss.virtual.plugins.context.vfs.AssembledFileHandler;
import org.jboss.virtual.plugins.context.vfs.AssembledUrlStreamHandler;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Assembled
public class AssembledDirectoryHandler
extends AbstractVirtualFileHandler
implements StructuredVirtualFileHandler {
    private long lastModified = System.currentTimeMillis();
    private List<VirtualFileHandler> children = new ArrayList<VirtualFileHandler>();
    private Map<String, VirtualFileHandler> childrenMap = new HashMap<String, VirtualFileHandler>();

    public AssembledDirectoryHandler(AssembledContext context, AssembledDirectoryHandler parent, String name) throws IOException {
        super(context, parent, name);
        String path = this.getPathName();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.setVfsUrl(new URL("vfs", context.getName(), -1, path, new AssembledUrlStreamHandler(context)));
    }

    public VirtualFileHandler addChild(VirtualFileHandler handler) {
        if (!handler.getClass().isAnnotationPresent(Assembled.class)) {
            try {
                handler = new AssembledFileHandler((AssembledContext)this.getVFSContext(), this, handler.getName(), handler);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.children.add(handler);
        this.childrenMap.put(handler.getName(), handler);
        this.lastModified = System.currentTimeMillis();
        return handler;
    }

    public VirtualFileHandler findChild(String name) {
        return this.childrenMap.get(name);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    @Override
    public URI toURI() throws URISyntaxException {
        return this.getVfsUrl().toURI();
    }

    @Override
    public long getLastModified() throws IOException {
        return this.lastModified;
    }

    @Override
    public long getSize() throws IOException {
        return 0L;
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    @Override
    public boolean isLeaf() throws IOException {
        return false;
    }

    @Override
    public boolean isHidden() throws IOException {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        throw new RuntimeException("Cannot open stream");
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        return this.children;
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        return this.childrenMap.get(name);
    }

    @Override
    public VirtualFile getVirtualFile() {
        this.checkClosed();
        this.increment();
        return new AssembledDirectory(this);
    }

    @Override
    public URL toURL() throws MalformedURLException, URISyntaxException {
        return this.getVfsUrl();
    }
}

