/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.jar.JarEntryHandler;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.context.jar.NestedJarHandler;
import org.jboss.virtual.plugins.context.jar.NoCopyNestedJarHandler;
import org.jboss.virtual.plugins.context.jar.SynthenticDirEntryHandler;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJarHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private transient JarFile jar;
    private transient List<VirtualFileHandler> entries;
    private transient Map<String, VirtualFileHandler> entryMap;

    protected static String getEntryName(JarEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        return entry.getName();
    }

    protected AbstractJarHandler(VFSContext context, VirtualFileHandler parent, URL url, String name) throws IOException {
        super(context, parent, url, name);
    }

    public JarFile getJar() {
        return this.jar;
    }

    protected void initJarFile(JarFile jarFile) throws IOException {
        this.jar = jarFile;
        Enumeration<JarEntry> enumeration = this.jar.entries();
        if (!enumeration.hasMoreElements()) {
            this.entries = Collections.emptyList();
            this.entryMap = Collections.emptyMap();
            return;
        }
        HashMap<String, VirtualFileHandler> parentMap = new HashMap<String, VirtualFileHandler>();
        ArrayList levelMapList = new ArrayList();
        this.entries = new ArrayList<VirtualFileHandler>();
        this.entryMap = new HashMap<String, VirtualFileHandler>();
        boolean trace = log.isTraceEnabled();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String[] paths = entry.getName().split("/");
            int n = paths.length;
            if (n >= levelMapList.size()) {
                for (int n2 = levelMapList.size(); n2 <= n; ++n2) {
                    levelMapList.add(new ArrayList());
                }
            }
            ArrayList levelMap = (ArrayList)levelMapList.get(n);
            levelMap.add(entry);
            if (!trace) continue;
            log.trace((Object)("added " + entry.getName() + " at depth " + n));
        }
        int level = 0;
        for (ArrayList arrayList : levelMapList) {
            if (trace) {
                log.trace((Object)("Level(" + level++ + "): " + arrayList));
            }
            for (JarEntry entry : arrayList) {
                AbstractURLHandler ehandler;
                String parentName;
                String name = entry.getName();
                int slash = entry.isDirectory() ? name.lastIndexOf(47, name.length() - 2) : name.lastIndexOf(47, name.length() - 1);
                VirtualFileHandler parent = this;
                String entryName = name;
                if (slash >= 0 && (parent = (VirtualFileHandler)parentMap.get(parentName = name.substring(0, slash + 1))) == null) {
                    parent = this.buildParents(parentName, parentMap, entry);
                }
                int start = slash + 1;
                int end = entry.isDirectory() ? name.length() - 1 : name.length();
                entryName = name.substring(start, end);
                VirtualFileHandler handler = this.createVirtualFileHandler(parent, entry, entryName);
                if (entry.isDirectory()) {
                    parentMap.put(name, handler);
                    if (trace) {
                        log.trace((Object)("Added parent: " + name));
                    }
                }
                if (parent == this) {
                    this.entries.add(handler);
                    this.entryMap.put(entryName, handler);
                    continue;
                }
                if (parent instanceof JarEntryHandler) {
                    ehandler = (JarEntryHandler)parent;
                    ((JarEntryHandler)ehandler).addChild(handler);
                    continue;
                }
                if (!(parent instanceof SynthenticDirEntryHandler)) continue;
                ehandler = (SynthenticDirEntryHandler)parent;
                ((SynthenticDirEntryHandler)ehandler).addChild(handler);
            }
        }
    }

    protected VirtualFileHandler buildParents(String parentName, Map<String, VirtualFileHandler> parentMap, JarEntry entry) throws IOException {
        VirtualFileHandler parent = this;
        String[] paths = PathTokenizer.getTokens(parentName);
        StringBuilder pathName = new StringBuilder();
        for (String path : paths) {
            VirtualFileHandler next;
            block5: {
                next = null;
                pathName.append(path);
                pathName.append('/');
                try {
                    next = parent.findChild(path);
                }
                catch (IOException e) {
                    AbstractURLHandler ehandler;
                    URL url = this.getURL(parent, path, true);
                    next = new SynthenticDirEntryHandler(this.getVFSContext(), parent, path, entry.getTime(), url);
                    parentMap.put(pathName.toString(), next);
                    if (parent == this) {
                        this.entries.add(next);
                        this.entryMap.put(path, next);
                    }
                    if (parent instanceof JarEntryHandler) {
                        ehandler = (JarEntryHandler)parent;
                        ((JarEntryHandler)ehandler).addChild(next);
                    }
                    if (!(parent instanceof SynthenticDirEntryHandler)) break block5;
                    ehandler = (SynthenticDirEntryHandler)parent;
                    ((SynthenticDirEntryHandler)ehandler).addChild(next);
                }
            }
            parent = next;
        }
        return parent;
    }

    protected URL getURL(VirtualFileHandler parent, String path, boolean isDirEntry) throws MalformedURLException {
        StringBuilder buffer = new StringBuilder();
        try {
            String parentUrl = parent.toURL().toString();
            if (parent instanceof JarEntryHandler || parent instanceof SynthenticDirEntryHandler) {
                buffer.append(parentUrl);
            } else {
                buffer.append("jar:").append(parentUrl).append("!/");
            }
            if (buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
            buffer.append(path);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        if (isDirEntry && buffer.charAt(buffer.length() - 1) != '/') {
            buffer.append('/');
        }
        URL url = new URL(buffer.toString());
        return url;
    }

    @Override
    protected void doClose() {
    }

    @Override
    public boolean isLeaf() {
        this.checkClosed();
        return false;
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.checkClosed();
        return this.entries;
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        VirtualFileHandler child = this.entryMap.get(name);
        if (child == null) {
            throw new FileNotFoundException(this + " has no child: " + name);
        }
        return child;
    }

    protected VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, JarEntry entry, String entryName) throws IOException {
        String flag;
        boolean useNoCopyJarHandler;
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        URL url = this.getURL(parent, entryName, entry.isDirectory());
        VFSContext context = parent.getVFSContext();
        AbstractURLHandler vfh = JarUtils.isArchive(entry.getName()) ? ((useNoCopyJarHandler = Boolean.valueOf(flag = context.getOptions().get("useNoCopyJarHandler")).booleanValue()) ? new NoCopyNestedJarHandler(context, parent, this.jar, entry, url) : NestedJarHandler.create(context, parent, this.jar, entry, url, entryName)) : new JarEntryHandler(context, parent, this.jar, entry, entryName, url);
        return vfh;
    }

    public static JarFile fromURL(URL url) throws IOException {
        try {
            JarURLConnection jarConnection;
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                jarConnection = (JarURLConnection)connection;
            } else {
                URL jarUrl = new URL("jar:" + url + "!/");
                jarConnection = (JarURLConnection)jarUrl.openConnection();
            }
            jarConnection.setUseCaches(false);
            return jarConnection.getJarFile();
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        URL jarURL = super.getURL();
        String jarAsString = jarURL.toString();
        if (jarAsString.startsWith("file:")) {
            File fp = new File(jarAsString.substring(5));
            this.jar = new JarFile(fp);
        } else {
            URLConnection conn = jarURL.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jconn = (JarURLConnection)conn;
                this.jar = jconn.getJarFile();
            } else {
                throw new IOException("Cannot restore from non-JarURLConnection, url: " + jarURL);
            }
        }
    }
}

