/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.file.FileSystemContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private transient File file;
    private transient Map<String, VirtualFileHandler> childCache = Collections.synchronizedMap(new HashMap());

    public FileHandler(FileSystemContext context, VirtualFileHandler parent, File file, URL url) throws IOException {
        super(context, parent, url, file.getName());
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file.getCanonicalPath());
        }
        this.vfsUrl = new URL("vfs" + url.toString());
    }

    public FileHandler(FileSystemContext context, VirtualFileHandler parent, File file, URI uri) throws IOException {
        this(context, parent, file, uri.toURL());
    }

    @Override
    public URL toVfsUrl() throws MalformedURLException, URISyntaxException {
        if (this.vfsUrl == null) {
            this.vfsUrl = new URL("vfs" + this.getURL().toString());
        }
        return this.vfsUrl;
    }

    @Override
    public FileSystemContext getVFSContext() {
        return (FileSystemContext)super.getVFSContext();
    }

    protected File getFile() {
        this.checkClosed();
        return this.file;
    }

    @Override
    public long getLastModified() {
        return this.getFile().lastModified();
    }

    @Override
    public long getSize() {
        return this.getFile().length();
    }

    @Override
    public boolean isLeaf() {
        return this.getFile().isFile();
    }

    @Override
    public boolean isHidden() {
        return this.getFile().isHidden();
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        File parent = this.getFile();
        File[] files = parent.listFiles();
        if (files == null) {
            throw new IOException("Error listing files: " + parent.getCanonicalPath());
        }
        ArrayList<File> tmpFiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.canRead()) continue;
            tmpFiles.add(file);
        }
        if (tmpFiles.isEmpty()) {
            return Collections.emptyList();
        }
        files = tmpFiles.toArray(new File[tmpFiles.size()]);
        FileSystemContext context = this.getVFSContext();
        ArrayList<VirtualFileHandler> result = new ArrayList<VirtualFileHandler>();
        Map<String, VirtualFileHandler> newCache = Collections.synchronizedMap(new HashMap());
        Map<String, VirtualFileHandler> oldCache = this.childCache;
        for (File file : files) {
            try {
                VirtualFileHandler handler = oldCache.get(file.getName());
                if (handler != null && handler.hasBeenModified()) {
                    handler = null;
                }
                if (handler == null) {
                    handler = context.createVirtualFileHandler(this, file);
                }
                result.add(handler);
                newCache.put(file.getName(), handler);
            }
            catch (IOException e) {
                if (ignoreErrors) {
                    log.trace((Object)("Ignored: " + e));
                    continue;
                }
                throw e;
            }
        }
        this.childCache = newCache;
        return result;
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        FileSystemContext context = this.getVFSContext();
        File parentFile = this.getFile();
        File child = new File(parentFile, name);
        VirtualFileHandler handler = this.childCache.get(name);
        if (handler != null && handler.hasBeenModified()) {
            handler = null;
        }
        if (handler == null) {
            handler = context.createVirtualFileHandler(this, child);
            this.childCache.put(name, handler);
        }
        return handler;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.file = new File(this.getURL().getPath());
    }
}

