/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.memory;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryContextHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private transient List<VirtualFileHandler> entryChildren = Collections.emptyList();
    private transient Map<String, MemoryContextHandler> entryMap = Collections.emptyMap();
    private byte[] contents;

    public MemoryContextHandler(VFSContext context, VirtualFileHandler parent, URL url, String name) {
        super(context, parent, url, name);
        if (parent != null) {
            ((MemoryContextHandler)parent).addChild(name, this);
        }
    }

    private void addChild(String name, MemoryContextHandler child) {
        if (this.entryChildren == Collections.EMPTY_LIST) {
            this.entryChildren = new ArrayList<VirtualFileHandler>();
        }
        if (this.entryMap == Collections.EMPTY_MAP) {
            this.entryMap = new HashMap<String, MemoryContextHandler>();
        }
        this.entryChildren.add(child);
        this.entryMap.put(name, child);
    }

    boolean deleteChild(MemoryContextHandler child) {
        boolean removedA = this.entryMap.remove(child.getName()) != null;
        boolean removedB = this.entryChildren.remove(child);
        return removedA && removedB;
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    MemoryContextHandler getDirectChild(String name) {
        return this.entryMap.get(name);
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        return this.entryChildren;
    }

    @Override
    public boolean isLeaf() {
        return this.contents != null;
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        VirtualFileHandler child = this.entryMap.get(name);
        if (child == null) {
            throw new FileNotFoundException(this + " has no child: " + name);
        }
        return child;
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        if (this.entryChildren.size() > 0) {
            throw new RuntimeException("Cannot set contents for non-leaf node");
        }
        this.initCacheLastModified();
        this.contents = contents;
    }

    @Override
    protected void initCacheLastModified() {
        this.cachedLastModified = System.currentTimeMillis();
    }

    @Override
    public long getSize() throws IOException {
        if (this.contents != null) {
            return this.contents.length;
        }
        return 0L;
    }

    @Override
    public long getLastModified() throws IOException {
        return this.cachedLastModified;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.contents != null) {
            return new ByteArrayInputStream(this.contents);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public URL toVfsUrl() throws MalformedURLException, URISyntaxException {
        if (this.vfsUrl == null) {
            if (this.isLeaf()) {
                this.vfsUrl = this.getURL();
            } else {
                String vfsString = this.getURL().toString();
                if (!vfsString.endsWith("/")) {
                    // empty if block
                }
                this.vfsUrl = new URL(vfsString + "/");
            }
        }
        return this.vfsUrl;
    }
}

