/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntryHandler
extends AbstractVirtualFileHandler
implements StructuredVirtualFileHandler {
    private final URL url;

    public ZipEntryHandler(ZipEntryContext context, AbstractVirtualFileHandler parent, String name, boolean isLeaf) throws IOException {
        super(context, parent, name);
        this.url = context.getChildURL(parent, name);
        String currentUrl = this.url.toString();
        int pos = currentUrl.indexOf(":/");
        StringBuilder vfsUrl = new StringBuilder();
        vfsUrl.append("vfszip:").append(currentUrl.substring(pos + 1));
        try {
            if (!isLeaf && vfsUrl.charAt(vfsUrl.length() - 1) != '/') {
                vfsUrl.append("/");
            }
            this.setVfsUrl(new URL(vfsUrl.toString()));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("ASSERTION ERROR - failed to set vfsUrl: " + vfsUrl, ex);
        }
        if (parent != null) {
            context.addChild(parent, this);
        }
    }

    @Override
    public URI toURI() throws URISyntaxException {
        return VFSUtils.toURI(this.url);
    }

    @Override
    public long getLastModified() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().getLastModified(this);
    }

    @Override
    public long getSize() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().getSize(this);
    }

    @Override
    public boolean exists() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().exists(this);
    }

    @Override
    public boolean isLeaf() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().isLeaf(this);
    }

    @Override
    public boolean isHidden() throws IOException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean isNested() throws IOException {
        return ZipEntryContext.isNested(this);
    }

    @Override
    public InputStream openStream() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().openStream(this);
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().getChildren(this, ignoreErrors);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        this.checkClosed();
        return this.structuredFindChild(path);
    }

    @Override
    public boolean removeChild(String name) throws IOException {
        return false;
    }

    @Override
    public boolean delete(int gracePeriod) throws IOException {
        this.checkClosed();
        boolean deleted = this.getZipEntryContext().delete(this, gracePeriod);
        if (deleted) {
            super.delete(gracePeriod);
        }
        return deleted;
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        return this.getZipEntryContext().getChild(this, name);
    }

    @Override
    protected void internalReplaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        if (!(original instanceof AbstractVirtualFileHandler)) {
            throw new IllegalArgumentException("Original file handler not found in this context: " + original);
        }
        this.getZipEntryContext().replaceChild(this, (AbstractVirtualFileHandler)original, replacement);
    }

    private ZipEntryContext getZipEntryContext() {
        return (ZipEntryContext)this.getLocalVFSContext();
    }
}

