/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.IOException;
import java.io.InputStream;

public class SizeLimitedInputStream
extends InputStream {
    private InputStream in;
    private long togo;

    public SizeLimitedInputStream(InputStream ins, long size) {
        this.in = ins;
        this.togo = size;
    }

    public int read() throws IOException {
        int b = -1;
        if (this.togo > 0L && (b = this.in.read()) != -1) {
            --this.togo;
        }
        return b;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offs, int len) throws IOException {
        int rc = -1;
        if (this.togo > 0L) {
            int ltogo = (int)this.togo;
            rc = ltogo < len ? ltogo : len;
            if ((rc = this.in.read(buf, offs, rc)) != -1) {
                this.togo -= (long)rc;
            }
        }
        return rc;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

