/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.virtual.plugins.context.AbstractContextFactory;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.spi.VFSContext;

public class ZipEntryContextFactory
extends AbstractContextFactory {
    private static Map<String, ZipEntryContext> ctxCache = new ConcurrentHashMap<String, ZipEntryContext>();
    private static ZipEntryContextFactory instance = new ZipEntryContextFactory();

    public ZipEntryContextFactory() {
        super("zip", "vfszip");
    }

    public VFSContext getVFS(URI rootURI) throws IOException {
        return this.getVFS(rootURI.toURL());
    }

    public VFSContext getVFS(URL rootURL) throws IOException {
        String key = rootURL.toString();
        int cutPos = key.indexOf(":/");
        key = key.substring(cutPos + 1);
        String longestMatchingKey = null;
        ZipEntryContext longestMatchingCtx = null;
        for (Map.Entry<String, ZipEntryContext> ent : ctxCache.entrySet()) {
            if (!key.startsWith(ent.getKey()) || longestMatchingCtx != null && ent.getKey().length() <= longestMatchingKey.length()) continue;
            longestMatchingKey = ent.getKey();
            longestMatchingCtx = ent.getValue();
        }
        ZipEntryContext ctx = null;
        if (longestMatchingCtx != null) {
            ctx = longestMatchingCtx;
        }
        if (ctx != null) {
            return ctx;
        }
        try {
            ctx = new ZipEntryContext(rootURL);
        }
        catch (URISyntaxException ex) {
            MalformedURLException e = new MalformedURLException("Failed to convert URL to URI: " + rootURL);
            e.initCause(ex);
            throw e;
        }
        return ctx;
    }

    public static ZipEntryContextFactory getInstance() {
        return instance;
    }

    public static void registerContext(ZipEntryContext ctx) {
        String key = ctx.getRootURI().toString();
        int cutPos = key.indexOf(":/");
        if ("".equals(key = key.substring(cutPos + 1))) {
            throw new RuntimeException("Derived key for ZipEntryContext registration is empty: " + ctx.getRootURI());
        }
        ctxCache.put(key, ctx);
    }
}

