/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.IOException;
import java.io.InputStream;

public class SizeLimitedInputStream
extends InputStream {
    private InputStream in;
    private int togo;

    public SizeLimitedInputStream(InputStream ins, int size) {
        this.in = ins;
        this.togo = size;
    }

    public int read() throws IOException {
        int b = -1;
        if (this.togo > 0 && (b = this.in.read()) != -1) {
            --this.togo;
        }
        return b;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offs, int len) throws IOException {
        int rc = -1;
        if (this.togo > 0) {
            rc = this.togo < len ? this.togo : len;
            if ((rc = this.in.read(buf, offs, rc)) != -1) {
                this.togo -= rc;
            }
        }
        return rc;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

