/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;

final class StringModelValue
extends ModelValue {
    private final String value;

    StringModelValue(String value) {
        super(ModelType.STRING);
        this.value = value;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    @Override
    long asLong() {
        return Long.parseLong(this.value);
    }

    @Override
    long asLong(long defVal) {
        return Long.parseLong(this.value);
    }

    @Override
    int asInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    int asInt(int defVal) {
        return Integer.parseInt(this.value);
    }

    @Override
    boolean asBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    double asDouble() {
        return Double.parseDouble(this.value);
    }

    @Override
    double asDouble(double defVal) {
        return Double.parseDouble(this.value);
    }

    @Override
    byte[] asBytes() {
        try {
            return this.value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return this.value.getBytes();
        }
    }

    @Override
    BigDecimal asBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    BigInteger asBigInteger() {
        return new BigInteger(this.value);
    }

    @Override
    String asString() {
        return this.value;
    }

    @Override
    ModelType asType() {
        return ModelType.valueOf(this.value);
    }

    @Override
    void format(StringBuilder builder, int indent, boolean multiLine) {
        builder.append(StringModelValue.quote(this.value));
    }

    @Override
    void formatAsJSON(StringBuilder builder, int indent, boolean multiLine) {
        builder.append(StringModelValue.jsonEscape(this.asString()));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof StringModelValue && this.equals((StringModelValue)other);
    }

    public boolean equals(StringModelValue other) {
        return this == other || other != null && this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

