/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Parser;
import org.yuanheng.cookcc.CookCCOption;
import org.yuanheng.cookcc.CookCCToken;
import org.yuanheng.cookcc.Lex;
import org.yuanheng.cookcc.Lexs;
import org.yuanheng.cookcc.Rule;
import org.yuanheng.cookcc.Rules;

@CookCCOption
class ModelNodeParser
extends Parser {
    private static final byte[] NO_BYTES = new byte[0];
    private ModelNode result;

    ModelNodeParser() {
    }

    @Lexs(patterns={@Lex(pattern="\\{", token="OPEN_BRACE"), @Lex(pattern="\\}", token="CLOSE_BRACE"), @Lex(pattern="\\[", token="OPEN_BRACKET"), @Lex(pattern="\\]", token="CLOSE_BRACKET"), @Lex(pattern="\\(", token="OPEN_PAREN"), @Lex(pattern="\\)", token="CLOSE_PAREN"), @Lex(pattern=",", token="COMMA"), @Lex(pattern="=>", token="ARROW"), @Lex(pattern="true", token="TRUE"), @Lex(pattern="false", token="FALSE"), @Lex(pattern="big", token="BIG"), @Lex(pattern="bytes", token="BYTES"), @Lex(pattern="decimal", token="DECIMAL"), @Lex(pattern="integer", token="INTEGER"), @Lex(pattern="expression", token="EXPRESSION"), @Lex(pattern="undefined", token="UNDEFINED")})
    protected Void parseToken() {
        return null;
    }

    @Lexs(patterns={@Lex(pattern="[+-]?[0-9]+L", token="LONG_VAL"), @Lex(pattern="[+-]?0x[0-9a-fA-F]+L", token="LONG_HEX_VAL"), @Lex(pattern="[+-]?[0-9]+", token="INT_VAL"), @Lex(pattern="[+-]?0x[0-9a-fA-F]+", token="INT_HEX_VAL"), @Lex(pattern="[+-]?(NaN|Infinity)", token="DOUBLE_SPECIAL_VAL"), @Lex(pattern="[+-]?([0-9]+\\.[0-9]+([eE][+-]?[0-9]+)?)", token="DEC_VAL"), @Lex(pattern="BIG_DECIMAL|BIG_INTEGER|BOOLEAN|BYTES|DOUBLE|EXPRESSION|INT|LIST|LONG|OBJECT|PROPERTY|STRING|TYPE|UNDEFINED", token="TYPE_VAL")})
    protected String parsePlainValue() {
        return this.yyText();
    }

    @Lex(pattern="\\\"([^\"\\\\]+|\\.)*\\\"", token="STR_VAL")
    protected String parseStringValue() {
        String yyText = this.yyText();
        int length = yyText.length();
        StringBuilder b = new StringBuilder(length);
        int i = 1;
        while (i < length - 1) {
            int ch = yyText.codePointAt(i);
            block0 : switch (ch) {
                case 92: {
                    i = yyText.offsetByCodePoints(i, 1);
                    ch = yyText.codePointAt(i);
                    switch (ch) {
                        case 110: {
                            b.append('\n');
                            break block0;
                        }
                        case 114: {
                            b.append('\r');
                            break block0;
                        }
                        case 98: {
                            b.append('\b');
                            break block0;
                        }
                        case 102: {
                            b.append('\f');
                            break block0;
                        }
                        case 117: {
                            b.append((char)Integer.parseInt(yyText.substring(i + 1, i + 5)));
                            i += 4;
                            break block0;
                        }
                    }
                    b.appendCodePoint(ch);
                    break;
                }
                default: {
                    b.appendCodePoint(ch);
                }
            }
            i = yyText.offsetByCodePoints(i, 1);
        }
        return b.toString();
    }

    @Lex(pattern="[ \\t\\r\\n]+")
    protected void ignored() {
    }

    @Lex(pattern=".")
    protected void invalid() throws IOException {
        throw new IOException("Invalid character: " + this.yyText());
    }

    @Lex(pattern="<<EOF>>", token="$")
    protected void parseEOF() {
    }

    @Rule(lhs="complete", rhs="node", args="1")
    protected int parse(ModelNode node) {
        this.result = node;
        return 0;
    }

    @Rules(rules={@Rule(lhs="node", rhs="BIG DECIMAL DEC_VAL", args="3"), @Rule(lhs="node", rhs="BIG DECIMAL INT_VAL", args="3")})
    protected ModelNode parseBigDecimal(String arg) {
        return new ModelNode().set(new BigDecimal(arg));
    }

    @Rule(lhs="node", rhs="BIG INTEGER INT_VAL", args="3")
    protected ModelNode parseBigInteger(String arg) {
        return new ModelNode().set(new BigInteger(arg));
    }

    @Rules(rules={@Rule(lhs="node", rhs="TRUE"), @Rule(lhs="node", rhs="FALSE")})
    protected ModelNode parseBoolean() {
        return new ModelNode().set(Boolean.parseBoolean(this.yyText()));
    }

    @Rules(rules={@Rule(lhs="bytes", rhs="BYTES OPEN_BRACE INT_VAL", args="3")})
    protected ByteArrayOutputStream startBytesInt(String val) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(Integer.parseInt(val));
        return baos;
    }

    @Rules(rules={@Rule(lhs="bytes", rhs="BYTES OPEN_BRACE INT_HEX_VAL", args="3")})
    protected ByteArrayOutputStream startBytesHex(String val) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(Integer.parseInt(val.substring(2), 16));
        return baos;
    }

    @Rules(rules={@Rule(lhs="bytes", rhs="bytes COMMA INT_VAL", args="1 3")})
    protected ByteArrayOutputStream nextByteInt(ByteArrayOutputStream baos, String val) {
        baos.write(Integer.parseInt(val));
        return baos;
    }

    @Rules(rules={@Rule(lhs="bytes", rhs="bytes COMMA INT_HEX_VAL", args="1 3")})
    protected ByteArrayOutputStream nextByteHex(ByteArrayOutputStream baos, String val) {
        baos.write(Integer.parseInt(val.substring(2), 16));
        return baos;
    }

    @Rules(rules={@Rule(lhs="node", rhs="bytes CLOSE_BRACE", args="1"), @Rule(lhs="node", rhs="bytes COMMA CLOSE_BRACE", args="1")})
    protected ModelNode finishBytes(ByteArrayOutputStream baos) {
        return new ModelNode().set(baos.toByteArray());
    }

    @Rules(rules={@Rule(lhs="node", rhs="BYTES OPEN_BRACE CLOSE_BRACE")})
    protected ModelNode emptyBytes() {
        return new ModelNode().set(NO_BYTES);
    }

    @Rules(rules={@Rule(lhs="node", rhs="DEC_VAL", args="1")})
    protected ModelNode parseDouble(String arg) {
        return new ModelNode().set(Double.parseDouble(arg));
    }

    @Rules(rules={@Rule(lhs="node", rhs="EXPRESSION STR_VAL", args="2")})
    protected ModelNode parseExpression(String arg) {
        return new ModelNode().setExpression(arg);
    }

    @Rules(rules={@Rule(lhs="node", rhs="INT_VAL", args="1")})
    protected ModelNode parseInt(String arg) {
        return new ModelNode().set(Integer.parseInt(arg));
    }

    @Rules(rules={@Rule(lhs="node", rhs="INT_HEX_VAL", args="1")})
    protected ModelNode parseIntHex(String arg) {
        return new ModelNode().set(Integer.parseInt(arg.substring(2), 16));
    }

    @Rules(rules={@Rule(lhs="node", rhs="LONG_VAL", args="1")})
    protected ModelNode parseLong(String arg) {
        return new ModelNode().set(Long.parseLong(arg));
    }

    @Rules(rules={@Rule(lhs="node", rhs="LONG_HEX_VAL", args="1")})
    protected ModelNode parseLongHex(String arg) {
        return new ModelNode().set(Long.parseLong(arg.substring(2), 16));
    }

    @Rules(rules={@Rule(lhs="node", rhs="OPEN_BRACKET CLOSE_BRACKET")})
    protected ModelNode parseEmptyList() {
        return new ModelNode().setEmptyList();
    }

    @Rules(rules={@Rule(lhs="list", rhs="OPEN_BRACKET node", args="2")})
    protected ModelNode parseStartList(ModelNode child) {
        return new ModelNode().addNoCopy(child);
    }

    @Rules(rules={@Rule(lhs="list", rhs="list COMMA node", args="1 3")})
    protected ModelNode parseListItem(ModelNode list, ModelNode child) {
        return list.addNoCopy(child);
    }

    @Rules(rules={@Rule(lhs="node", rhs="list CLOSE_BRACKET", args="1"), @Rule(lhs="node", rhs="list COMMA CLOSE_BRACKET", args="1")})
    protected ModelNode finishList(ModelNode list) {
        return list;
    }

    @Rules(rules={@Rule(lhs="node", rhs="OPEN_BRACE CLOSE_BRACE")})
    protected ModelNode parseEmptyObject() {
        return new ModelNode().setEmptyObject();
    }

    @Rules(rules={@Rule(lhs="object", rhs="OPEN_BRACE STR_VAL ARROW node", args="2 4")})
    protected ModelNode parseStartObject(String key, ModelNode child) {
        ModelNode node = new ModelNode();
        node.get(key).setNoCopy(child);
        return node;
    }

    @Rules(rules={@Rule(lhs="object", rhs="object COMMA STR_VAL ARROW node", args="1 3 5")})
    protected ModelNode parseObjectItem(ModelNode object, String key, ModelNode child) {
        object.get(key).setNoCopy(child);
        return object;
    }

    @Rules(rules={@Rule(lhs="node", rhs="object CLOSE_BRACE", args="1"), @Rule(lhs="node", rhs="object COMMA CLOSE_BRACE", args="1")})
    protected ModelNode finishObject(ModelNode object) {
        return object;
    }

    @Rules(rules={@Rule(lhs="node", rhs="OPEN_PAREN STR_VAL ARROW node CLOSE_PAREN", args="2 4")})
    protected ModelNode parseProperty(String key, ModelNode value) {
        return new ModelNode().setNoCopy(key, value);
    }

    @Rules(rules={@Rule(lhs="node", rhs="STR_VAL", args="1")})
    protected ModelNode parseString(String arg) {
        return new ModelNode().set(arg);
    }

    @Rules(rules={@Rule(lhs="node", rhs="TYPE_VAL", args="1")})
    protected ModelNode parseType(String arg) {
        return new ModelNode().set(ModelType.valueOf(arg));
    }

    @Rule(lhs="node", rhs="UNDEFINED")
    protected ModelNode parseUndefined() {
        return new ModelNode();
    }

    public ModelNode getResult() {
        return this.result;
    }

    @CookCCToken
    static enum Token {
        OPEN_BRACE,
        CLOSE_BRACE,
        OPEN_BRACKET,
        CLOSE_BRACKET,
        OPEN_PAREN,
        CLOSE_PAREN,
        ARROW,
        COMMA,
        BIG,
        BYTES,
        INTEGER,
        DECIMAL,
        EXPRESSION,
        UNDEFINED,
        TRUE,
        FALSE,
        INT_VAL,
        INT_HEX_VAL,
        LONG_VAL,
        LONG_HEX_VAL,
        DOUBLE_SPECIAL_VAL,
        DEC_VAL,
        STR_VAL,
        TYPE_VAL;

    }
}

