/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;

final class BigIntegerModelValue
extends ModelValue {
    private final BigInteger value;

    BigIntegerModelValue(BigInteger value) {
        super(ModelType.BIG_INTEGER);
        this.value = value;
    }

    BigIntegerModelValue(DataInput in) throws IOException {
        super(ModelType.BIG_INTEGER);
        byte[] b = new byte[in.readInt()];
        in.readFully(b);
        this.value = new BigInteger(b);
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        byte[] b = this.value.toByteArray();
        out.writeInt(b.length);
        out.write(b);
    }

    @Override
    long asLong() {
        return this.value.longValue();
    }

    @Override
    long asLong(long defVal) {
        return this.value.longValue();
    }

    @Override
    int asInt() {
        return this.value.intValue();
    }

    @Override
    int asInt(int defVal) {
        return this.value.intValue();
    }

    @Override
    boolean asBoolean() {
        return !this.value.equals(BigInteger.ZERO);
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return !this.value.equals(BigInteger.ZERO);
    }

    @Override
    double asDouble() {
        return this.value.doubleValue();
    }

    @Override
    double asDouble(double defVal) {
        return this.value.doubleValue();
    }

    @Override
    BigDecimal asBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    BigInteger asBigInteger() {
        return this.value;
    }

    @Override
    String asString() {
        return this.value.toString();
    }

    @Override
    void format(StringBuilder target, int indent, boolean ignored) {
        target.append("big integer ").append(this.value);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BigIntegerModelValue && this.equals((BigIntegerModelValue)other);
    }

    public boolean equals(BigIntegerModelValue other) {
        return this == other || other != null && this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

