/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;

public class Main {
    private boolean modify;
    private boolean verbose;
    private boolean dump;
    private File outputFile;
    private File source;

    public static void main(String[] args) {
        if (args.length == 0) {
            Main.printUsage();
            return;
        }
        Main main = new Main();
        main.execute(args);
    }

    private void execute(String[] args) {
        try {
            this.parseOptions(args);
            if (this.dump) {
                this.dumpIndex(this.source);
                return;
            }
            long start = System.currentTimeMillis();
            Indexer indexer = new Indexer();
            Result result = this.source.isDirectory() ? this.indexDirectory(this.source, indexer) : this.indexJar(this.source, indexer);
            double time = (double)(System.currentTimeMillis() - start) / 1000.0;
            System.out.printf("Wrote %s in %.4f seconds (%d classes, %d annotations, %d instances, %d bytes)\n", result.name, time, result.classes, result.annotations, result.instances, result.bytes);
        }
        catch (Exception e) {
            if (!this.verbose && (e instanceof IllegalArgumentException || e instanceof FileNotFoundException)) {
                System.err.println(e.getMessage() == null ? e.getClass().getSimpleName() : "ERROR: " + e.getMessage());
            } else {
                e.printStackTrace(System.err);
            }
            System.out.println();
            Main.printUsage();
        }
    }

    private void dumpIndex(File source) throws IOException {
        FileInputStream input = new FileInputStream(source);
        IndexReader reader = new IndexReader(input);
        long start = System.currentTimeMillis();
        Index index = reader.read();
        long end = System.currentTimeMillis() - start;
        index.printAnnotations();
        index.printSubclasses();
        System.out.printf("\nRead %s in %.04f seconds\n", source.getName(), (double)end / 1000.0);
    }

    private Result indexDirectory(File source, Indexer indexer) throws FileNotFoundException, IOException {
        File outputFile = this.outputFile;
        this.scanFile(source, indexer);
        if (this.modify) {
            new File(source, "META-INF").mkdirs();
            outputFile = new File(source, "META-INF/jandex.idx");
        }
        if (outputFile == null) {
            outputFile = new File(String.valueOf(source.getName().replace('.', '-')) + ".idx");
        }
        FileOutputStream out = new FileOutputStream(outputFile);
        IndexWriter writer = new IndexWriter(out);
        try {
            Index index = indexer.complete();
            int bytes = writer.write(index);
            Result result = new Result(index, outputFile.getPath(), bytes);
            return result;
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private Result indexJar(File source, Indexer indexer) throws IOException {
        boolean modify = this.modify;
        boolean verbose = this.verbose;
        File tmpCopy = null;
        ZipOutputStream zo = null;
        OutputStream out = null;
        JarFile jar = new JarFile(source);
        if (modify) {
            tmpCopy = File.createTempFile(source.getName().substring(0, source.getName().lastIndexOf(46)), "jmp");
            zo = new ZipOutputStream(new FileOutputStream(tmpCopy));
            out = zo;
        } else {
            if (this.outputFile == null) {
                this.outputFile = new File(String.valueOf(source.getName().replace('.', '-')) + ".idx");
            }
            out = new FileOutputStream(this.outputFile);
        }
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (modify) {
                    zo.putNextEntry(entry);
                    this.copy(jar.getInputStream(entry), zo);
                }
                if (!entry.getName().endsWith(".class")) continue;
                ClassInfo info = indexer.index(jar.getInputStream(entry));
                if (!verbose || info == null) continue;
                this.printIndexEntryInfo(info);
            }
            if (modify) {
                zo.putNextEntry(new ZipEntry("META-INF/jandex.idx"));
            }
            IndexWriter writer = new IndexWriter(out);
            Index index = indexer.complete();
            int bytes = writer.write(index);
            if (modify) {
                source.delete();
                tmpCopy.renameTo(source);
                tmpCopy = null;
            }
            Result result = new Result(index, modify ? "META-INF/jandex.idx" : this.outputFile.getPath(), bytes);
            return result;
        }
        finally {
            out.flush();
            out.close();
            if (tmpCopy != null) {
                tmpCopy.delete();
            }
        }
    }

    private void printIndexEntryInfo(ClassInfo info) {
        System.out.println("Indexed " + info.name() + " (" + info.annotations().size() + " annotations)");
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    private void scanFile(File source, Indexer indexer) throws FileNotFoundException, IOException {
        if (source.isDirectory()) {
            File[] children = source.listFiles();
            if (children == null) {
                throw new FileNotFoundException("Source directory disappeared: " + source);
            }
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.scanFile(child, indexer);
                ++n2;
            }
            return;
        }
        FileInputStream input = new FileInputStream(source);
        ClassInfo info = indexer.index(input);
        if (this.verbose) {
            this.printIndexEntryInfo(info);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: jandex [-v] [-m] [-o file-name] <directory> | <jar>");
        System.out.println("        -or-");
        System.out.println("       jandex [-d] <index-file-name>");
        System.out.println("Options:");
        System.out.println("  -v  verbose output");
        System.out.println("  -m  modify directory or jar instead of creating an external index file");
        System.out.println("  -o  name the external index file file-name");
        System.out.println("  -d  dump the index file index-file-name");
        System.out.println("\nThe default behavior, with no options specified, is to autogenerate an external index file");
    }

    private void parseOptions(String[] args) {
        int optionCount = 0;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.length() < 2 || arg.charAt(0) != '-') {
                if (this.source != null) {
                    throw new IllegalArgumentException("Only one source location can be specified");
                }
                this.source = new File(arg);
                if (!this.source.exists()) {
                    throw new IllegalArgumentException("Source directory/jar not found: " + this.source.getName());
                }
            } else {
                switch (arg.charAt(1)) {
                    case 'm': {
                        this.modify = true;
                        ++optionCount;
                        break;
                    }
                    case 'd': {
                        this.dump = true;
                        ++optionCount;
                        break;
                    }
                    case 'v': {
                        this.verbose = true;
                        ++optionCount;
                        break;
                    }
                    case 'o': {
                        String name;
                        if (i >= args.length) {
                            throw new IllegalArgumentException("-o reuires an output file name");
                        }
                        if ((name = args[++i]).length() < 1) {
                            throw new IllegalArgumentException("-o reuires an output file name");
                        }
                        this.outputFile = new File(name);
                        ++optionCount;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Option not understood: " + arg);
                    }
                }
            }
            ++i;
        }
        if (this.source == null) {
            throw new IllegalArgumentException("Source location not specified");
        }
        if (this.outputFile != null && this.modify) {
            throw new IllegalArgumentException("-o and -m are mutually exclusive");
        }
        if (this.dump && optionCount != 1) {
            throw new IllegalArgumentException("-d can not be specified with other options");
        }
    }

    private static class Result {
        private int annotations;
        private int instances;
        private int classes;
        private int bytes;
        private String name;

        private Result(Index index, String name, int bytes) {
            this.annotations = index.annotations.size();
            this.instances = this.countInstances(index);
            this.classes = index.classes.size();
            this.bytes = bytes;
            this.name = name;
        }

        private int countInstances(Index index) {
            int c = 0;
            for (List<AnnotationInstance> list : index.annotations.values()) {
                c += list.size();
            }
            return c;
        }
    }
}

