/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PackedDataInputStream;
import org.jboss.jandex.Type;
import org.jboss.jandex.UnsupportedVersion;

public final class IndexReader {
    private static final int MAGIC = -1161945323;
    private static final byte VERSION = 2;
    private static final byte FIELD_TAG = 1;
    private static final byte METHOD_TAG = 2;
    private static final byte METHOD_PARAMATER_TAG = 3;
    private static final byte CLASS_TAG = 4;
    private static final int AVALUE_BYTE = 1;
    private static final int AVALUE_SHORT = 2;
    private static final int AVALUE_INT = 3;
    private static final int AVALUE_CHAR = 4;
    private static final int AVALUE_FLOAT = 5;
    private static final int AVALUE_DOUBLE = 6;
    private static final int AVALUE_LONG = 7;
    private static final int AVALUE_BOOLEAN = 8;
    private static final int AVALUE_STRING = 9;
    private static final int AVALUE_CLASS = 10;
    private static final int AVALUE_ENUM = 11;
    private static final int AVALUE_ARRAY = 12;
    private static final int AVALUE_NESTED = 13;
    private InputStream input;
    private DotName[] classTable;
    private String[] stringTable;
    private HashMap<DotName, List<AnnotationInstance>> masterAnnotations;

    public IndexReader(InputStream input) {
        this.input = input;
    }

    public Index read() throws IOException {
        PackedDataInputStream stream = new PackedDataInputStream(new BufferedInputStream(this.input));
        if (stream.readInt() != -1161945323) {
            throw new IllegalArgumentException("Not a jandex index");
        }
        byte version = stream.readByte();
        if (version != 2) {
            throw new UnsupportedVersion("Version: " + version);
        }
        try {
            this.masterAnnotations = new HashMap();
            this.readClassTable(stream);
            this.readStringTable(stream);
            Index index = this.readClasses(stream);
            return index;
        }
        finally {
            this.classTable = null;
            this.stringTable = null;
            this.masterAnnotations = null;
        }
    }

    private Index readClasses(PackedDataInputStream stream) throws IOException {
        int entries = stream.readPackedU32();
        HashMap<DotName, List<ClassInfo>> subclasses = new HashMap<DotName, List<ClassInfo>>();
        HashMap<DotName, ClassInfo> classes = new HashMap<DotName, ClassInfo>();
        this.masterAnnotations = new HashMap();
        int i = 0;
        while (i < entries) {
            DotName name = this.classTable[stream.readPackedU32()];
            DotName superName = this.classTable[stream.readPackedU32()];
            short flags = stream.readShort();
            int numIntfs = stream.readPackedU32();
            DotName[] interfaces = new DotName[numIntfs];
            int j = 0;
            while (j < numIntfs) {
                interfaces[j] = this.classTable[stream.readPackedU32()];
                ++j;
            }
            HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>();
            ClassInfo clazz = new ClassInfo(name, superName, flags, interfaces, annotations);
            classes.put(name, clazz);
            this.addSubclass(subclasses, superName, clazz);
            this.readAnnotations(stream, annotations, clazz);
            ++i;
        }
        return new Index(this.masterAnnotations, subclasses, classes);
    }

    private void readAnnotations(PackedDataInputStream stream, Map<DotName, List<AnnotationInstance>> annotations, ClassInfo clazz) throws IOException {
        int numAnnotations = stream.readPackedU32();
        int j = 0;
        while (j < numAnnotations) {
            DotName annotationName = this.classTable[stream.readPackedU32()];
            int numTargets = stream.readPackedU32();
            int k = 0;
            while (k < numTargets) {
                AnnotationTarget target;
                int tag = stream.readPackedU32();
                switch (tag) {
                    case 1: {
                        String name = this.stringTable[stream.readPackedU32()];
                        Type type = this.readType(stream);
                        short flags = stream.readShort();
                        target = new FieldInfo(clazz, name, type, flags);
                        break;
                    }
                    case 2: {
                        target = this.readMethod(clazz, stream);
                        break;
                    }
                    case 3: {
                        MethodInfo method = this.readMethod(clazz, stream);
                        target = new MethodParameterInfo(method, (short)stream.readPackedU32());
                        break;
                    }
                    case 4: {
                        target = clazz;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                AnnotationValue[] values = this.readAnnotationValues(stream);
                AnnotationInstance instance = new AnnotationInstance(annotationName, target, values);
                this.recordAnnotation(this.masterAnnotations, annotationName, instance);
                this.recordAnnotation(annotations, annotationName, instance);
                ++k;
            }
            ++j;
        }
    }

    private AnnotationValue[] readAnnotationValues(PackedDataInputStream stream) throws IOException {
        int numValues = stream.readPackedU32();
        AnnotationValue[] values = new AnnotationValue[numValues];
        int i = 0;
        while (i < numValues) {
            AnnotationValue value;
            String name = this.stringTable[stream.readPackedU32()];
            byte tag = stream.readByte();
            switch (tag) {
                case 1: {
                    value = new AnnotationValue.ByteValue(name, stream.readByte());
                    break;
                }
                case 2: {
                    value = new AnnotationValue.ShortValue(name, (short)stream.readPackedU32());
                    break;
                }
                case 3: {
                    value = new AnnotationValue.IntegerValue(name, stream.readPackedU32());
                    break;
                }
                case 4: {
                    value = new AnnotationValue.CharacterValue(name, (char)stream.readPackedU32());
                    break;
                }
                case 5: {
                    value = new AnnotationValue.FloatValue(name, stream.readFloat());
                    break;
                }
                case 6: {
                    value = new AnnotationValue.DoubleValue(name, stream.readDouble());
                    break;
                }
                case 7: {
                    value = new AnnotationValue.LongValue(name, stream.readLong());
                    break;
                }
                case 8: {
                    value = new AnnotationValue.BooleanValue(name, stream.readBoolean());
                    break;
                }
                case 9: {
                    value = new AnnotationValue.StringValue(name, this.stringTable[stream.readPackedU32()]);
                    break;
                }
                case 10: {
                    value = new AnnotationValue.ClassValue(name, this.readType(stream));
                    break;
                }
                case 11: {
                    value = new AnnotationValue.EnumValue(name, this.classTable[stream.readPackedU32()], this.stringTable[stream.readPackedU32()]);
                    break;
                }
                case 12: {
                    value = new AnnotationValue.ArrayValue(name, this.readAnnotationValues(stream));
                    break;
                }
                case 13: {
                    DotName nestedName = this.classTable[stream.readPackedU32()];
                    AnnotationInstance nestedInstance = new AnnotationInstance(nestedName, null, this.readAnnotationValues(stream));
                    value = new AnnotationValue.NestedAnnotation(name, nestedInstance);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid annotation value tag:" + tag);
                }
            }
            values[i] = value;
            ++i;
        }
        return values;
    }

    private MethodInfo readMethod(ClassInfo clazz, PackedDataInputStream stream) throws IOException {
        String name = this.stringTable[stream.readPackedU32()];
        int numArgs = stream.readPackedU32();
        Type[] args = new Type[numArgs];
        int i = 0;
        while (i < numArgs) {
            args[i] = this.readType(stream);
            ++i;
        }
        Type returnType = this.readType(stream);
        short flags = stream.readShort();
        return new MethodInfo(clazz, name, args, returnType, flags);
    }

    private void recordAnnotation(Map<DotName, List<AnnotationInstance>> annotations, DotName annotation, AnnotationInstance instance) {
        List<AnnotationInstance> list = annotations.get(annotation);
        if (list == null) {
            list = new ArrayList<AnnotationInstance>();
            annotations.put(annotation, list);
        }
        list.add(instance);
    }

    private void addSubclass(HashMap<DotName, List<ClassInfo>> subclasses, DotName superName, ClassInfo currentClass) {
        List<ClassInfo> list = subclasses.get(superName);
        if (list == null) {
            list = new ArrayList<ClassInfo>();
            subclasses.put(superName, list);
        }
        list.add(currentClass);
    }

    private Type readType(PackedDataInputStream stream) throws IOException {
        Type.Kind kind = Type.Kind.fromOrdinal(stream.readByte());
        DotName name = this.classTable[stream.readPackedU32()];
        return new Type(name, kind);
    }

    private void readStringTable(PackedDataInputStream stream) throws IOException {
        int entries = stream.readPackedU32();
        this.stringTable = new String[entries];
        int i = 0;
        while (i < entries) {
            this.stringTable[i] = stream.readUTF();
            ++i;
        }
    }

    private void readClassTable(PackedDataInputStream stream) throws IOException {
        int entries = stream.readPackedU32();
        int lastDepth = -1;
        DotName curr = null;
        this.classTable = new DotName[++entries];
        int i = 1;
        while (i < entries) {
            int depth = stream.readPackedU32();
            String local = stream.readUTF();
            if (depth <= lastDepth) {
                while (lastDepth-- >= depth) {
                    curr = curr.prefix();
                }
            }
            this.classTable[i] = curr = new DotName(curr, local, true);
            lastDepth = depth;
            ++i;
        }
    }
}

