/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.ArrayDeque;

public final class DotName
implements Comparable<DotName> {
    private final DotName prefix;
    private final String local;
    private int hash;
    private boolean componentized = false;

    public static DotName createSimple(String name) {
        return new DotName(null, name, false);
    }

    public static DotName createComponentized(DotName prefix, String localName) {
        if (localName.indexOf(46) != -1) {
            throw new IllegalArgumentException("A componentized DotName can not contain '.' characters in a local name");
        }
        return new DotName(prefix, localName, true);
    }

    DotName(DotName prefix, String local, boolean noDots) {
        if (local == null) {
            throw new IllegalArgumentException("Local string can not be null");
        }
        this.prefix = prefix;
        this.local = local;
        this.componentized = (prefix == null || prefix.componentized) && noDots;
    }

    public DotName prefix() {
        return this.prefix;
    }

    public String local() {
        return this.local;
    }

    public boolean isComponentized() {
        return !this.componentized;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        if (this.prefix != null) {
            string.append(this.prefix).append(".");
        }
        string.append(this.local);
        return string.toString();
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash > 0) {
            return hash;
        }
        if (this.prefix != null) {
            hash = this.prefix.hashCode() * 31 + 46;
            int i = 0;
            while (i < this.local.length()) {
                hash = 31 * hash + this.local.charAt(i);
                ++i;
            }
        } else {
            hash = this.local.hashCode();
        }
        this.hash = hash;
        return this.hash;
    }

    @Override
    public int compareTo(DotName other) {
        if (this.componentized && other.componentized) {
            ArrayDeque<DotName> thisStack = new ArrayDeque<DotName>();
            ArrayDeque<DotName> otherStack = new ArrayDeque<DotName>();
            DotName curr = this;
            while (curr != null) {
                thisStack.push(curr);
                curr = curr.prefix();
            }
            curr = other;
            while (curr != null) {
                otherStack.push(curr);
                curr = curr.prefix();
            }
            int thisSize = thisStack.size();
            int otherSize = otherStack.size();
            int stop = Math.min(thisSize, otherSize);
            int i = 0;
            while (i < stop) {
                DotName thisComp = (DotName)thisStack.pop();
                DotName otherComp = (DotName)otherStack.pop();
                int comp = thisComp.local.compareTo(otherComp.local);
                if (comp != 0) {
                    return comp;
                }
                ++i;
            }
            int diff = thisSize - otherSize;
            if (diff != 0) {
                return diff;
            }
        }
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DotName)) {
            return false;
        }
        DotName other = (DotName)o;
        if (other.prefix == null && this.prefix == null) {
            return this.local.equals(other.local);
        }
        if (other.prefix == null && this.prefix != null) {
            return this.toString().equals(other.local);
        }
        if (other.prefix != null && this.prefix == null) {
            return other.toString().equals(this.local);
        }
        return this.local.equals(other.local) && this.prefix.equals(other.prefix);
    }
}

