/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PackedDataOutputStream;
import org.jboss.jandex.StrongInternPool;
import org.jboss.jandex.Type;

public final class IndexWriter {
    private static final int MAGIC = -1161945323;
    private static final byte VERSION = 1;
    private static final byte FIELD_TAG = 1;
    private static final byte METHOD_TAG = 2;
    private static final byte METHOD_PARAMATER_TAG = 3;
    private static final byte CLASS_TAG = 4;
    private final OutputStream out;
    private StrongInternPool<String> pool;
    StrongInternPool.Index poolIndex;
    private TreeMap<DotName, Integer> classTable;

    public IndexWriter(OutputStream out) {
        this.out = out;
    }

    public int write(Index index) throws IOException {
        PackedDataOutputStream stream = new PackedDataOutputStream(new BufferedOutputStream(this.out));
        stream.writeInt(-1161945323);
        stream.writeByte(1);
        this.buildTables(index);
        this.writeClassTable(stream);
        this.writeStringTable(stream);
        this.writeClasses(stream, index);
        stream.flush();
        return stream.size();
    }

    private void writeStringTable(PackedDataOutputStream stream) throws IOException {
        stream.writePackedU32(this.pool.size());
        Iterator<String> iter = this.pool.iterator();
        while (iter.hasNext()) {
            String string = iter.next();
            stream.writeUTF(string);
        }
    }

    private void writeClassTable(PackedDataOutputStream stream) throws IOException {
        stream.writePackedU32(this.classTable.size());
        int pos = 1;
        for (Map.Entry<DotName, Integer> entry : this.classTable.entrySet()) {
            entry.setValue(pos++);
            DotName name = entry.getKey();
            assert (!name.isComponentized());
            int nameDepth = 0;
            DotName prefix = name.prefix();
            while (prefix != null) {
                ++nameDepth;
                prefix = prefix.prefix();
            }
            stream.writePackedU32(nameDepth);
            stream.writeUTF(name.local());
        }
    }

    private int positionOf(String string) {
        int i = this.poolIndex.positionOf(string);
        if (i < 0) {
            throw new IllegalStateException();
        }
        return i;
    }

    private int positionOf(DotName className) {
        Integer i = this.classTable.get(className);
        if (i == null) {
            throw new IllegalStateException("Class not found in class table:" + className);
        }
        return i;
    }

    private void writeClasses(PackedDataOutputStream stream, Index index) throws IOException {
        Collection<ClassInfo> classes = index.getKnownClasses();
        stream.writePackedU32(classes.size());
        for (ClassInfo clazz : classes) {
            stream.writePackedU32(this.positionOf(clazz.name()));
            stream.writePackedU32(clazz.superName() == null ? 0 : this.positionOf(clazz.superName()));
            stream.writeShort(clazz.flags());
            DotName[] interfaces = clazz.interfaces();
            stream.writePackedU32(interfaces.length);
            DotName[] dotNameArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                DotName intf = dotNameArray[n2];
                stream.writePackedU32(this.positionOf(intf));
                ++n2;
            }
            Set<Map.Entry<DotName, List<AnnotationTarget>>> entrySet = clazz.annotations().entrySet();
            stream.writePackedU32(entrySet.size());
            for (Map.Entry<DotName, List<AnnotationTarget>> entry : entrySet) {
                stream.writePackedU32(this.positionOf(entry.getKey()));
                List<AnnotationTarget> targets = entry.getValue();
                stream.writePackedU32(targets.size());
                for (AnnotationTarget target : targets) {
                    if (target instanceof FieldInfo) {
                        FieldInfo field = (FieldInfo)target;
                        stream.writeByte(1);
                        stream.writePackedU32(this.positionOf(field.name()));
                        this.writeType(stream, field.type());
                        stream.writeShort(field.flags());
                        continue;
                    }
                    if (target instanceof MethodInfo) {
                        MethodInfo method = (MethodInfo)target;
                        stream.writeByte(2);
                        stream.writePackedU32(this.positionOf(method.name()));
                        stream.writePackedU32(method.args().length);
                        int i = 0;
                        while (i < method.args().length) {
                            this.writeType(stream, method.args()[i]);
                            ++i;
                        }
                        this.writeType(stream, method.returnType());
                        stream.writeShort(method.flags());
                        continue;
                    }
                    if (target instanceof MethodParameterInfo) {
                        MethodParameterInfo param = (MethodParameterInfo)target;
                        MethodInfo method = param.method();
                        stream.writeByte(3);
                        stream.writePackedU32(this.positionOf(method.name()));
                        stream.writePackedU32(method.args().length);
                        int i = 0;
                        while (i < method.args().length) {
                            this.writeType(stream, method.args()[i]);
                            ++i;
                        }
                        this.writeType(stream, method.returnType());
                        stream.writeShort(method.flags());
                        stream.writePackedU32(param.position());
                        continue;
                    }
                    if (target instanceof ClassInfo) {
                        stream.writeByte(4);
                        continue;
                    }
                    throw new IllegalStateException("Unknown target");
                }
            }
        }
    }

    private void writeType(PackedDataOutputStream stream, Type type) throws IOException {
        stream.writeByte(type.kind().ordinal());
        stream.writePackedU32(this.positionOf(type.name()));
    }

    private void buildTables(Index index) {
        this.pool = new StrongInternPool();
        this.classTable = new TreeMap();
        for (ClassInfo clazz : index.getKnownClasses()) {
            this.addClassName(clazz.name());
            if (clazz.superName() != null) {
                this.addClassName(clazz.superName());
            }
            DotName[] dotNameArray = clazz.interfaces();
            int n = dotNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                DotName intf = dotNameArray[n2];
                this.addClassName(intf);
                ++n2;
            }
            for (Map.Entry<DotName, List<AnnotationTarget>> entry : clazz.annotations().entrySet()) {
                this.addClassName(entry.getKey());
                for (AnnotationTarget target : entry.getValue()) {
                    Type type;
                    int n3;
                    int n4;
                    Type[] typeArray;
                    if (target instanceof FieldInfo) {
                        FieldInfo field = (FieldInfo)target;
                        this.intern(field.name());
                        this.addClassName(field.type().name());
                        continue;
                    }
                    if (target instanceof MethodInfo) {
                        MethodInfo method = (MethodInfo)target;
                        this.intern(method.name());
                        typeArray = method.args();
                        n4 = typeArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            type = typeArray[n3];
                            this.addClassName(type.name());
                            ++n3;
                        }
                        this.addClassName(method.returnType().name());
                        continue;
                    }
                    if (!(target instanceof MethodParameterInfo)) continue;
                    MethodParameterInfo param = (MethodParameterInfo)target;
                    this.intern(param.method().name());
                    typeArray = param.method().args();
                    n4 = typeArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        type = typeArray[n3];
                        this.addClassName(type.name());
                        ++n3;
                    }
                    this.addClassName(param.method().returnType().name());
                }
            }
        }
        this.poolIndex = this.pool.index();
    }

    private String intern(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.pool.intern(name);
    }

    private void addClassName(DotName name) {
        DotName prefix;
        if (!this.classTable.containsKey(name)) {
            this.classTable.put(name, null);
        }
        if ((prefix = name.prefix()) != null) {
            this.addClassName(prefix);
        }
    }
}

