/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

public final class Index {
    final Map<DotName, List<AnnotationTarget>> annotations;
    final Map<DotName, List<ClassInfo>> subclasses;
    final Map<DotName, ClassInfo> classes;

    Index(Map<DotName, List<AnnotationTarget>> annotations, Map<DotName, List<ClassInfo>> subclasses, Map<DotName, ClassInfo> classes) {
        this.annotations = Collections.unmodifiableMap(annotations);
        this.classes = Collections.unmodifiableMap(classes);
        this.subclasses = Collections.unmodifiableMap(subclasses);
    }

    public List<AnnotationTarget> getAnnotationTargets(DotName annotationName) {
        return Collections.unmodifiableList(this.annotations.get(annotationName));
    }

    public List<ClassInfo> getKnownSubclasses(DotName className) {
        return Collections.unmodifiableList(this.subclasses.get(className));
    }

    public ClassInfo getClassByName(DotName className) {
        return this.classes.get(className);
    }

    public Collection<ClassInfo> getKnownClasses() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public void printAnnotations() {
        System.out.println("Annotations:");
        for (Map.Entry<DotName, List<AnnotationTarget>> e : this.annotations.entrySet()) {
            System.out.println(e.getKey() + ":");
            for (AnnotationTarget target : e.getValue()) {
                if (target instanceof ClassInfo) {
                    System.out.println("    Class: " + target);
                    continue;
                }
                if (target instanceof FieldInfo) {
                    System.out.println("    Field: " + target);
                    continue;
                }
                if (target instanceof MethodInfo) {
                    System.out.println("    Method: " + target);
                    continue;
                }
                if (!(target instanceof MethodParameterInfo)) continue;
                System.out.println("    Parameter: " + target);
            }
        }
    }

    public void printSubclasses() {
        System.out.println("Subclasses:");
        for (Map.Entry<DotName, List<ClassInfo>> entry : this.subclasses.entrySet()) {
            System.out.println(entry.getKey() + ":");
            for (ClassInfo clazz : entry.getValue()) {
                System.out.println("    " + clazz.name());
            }
        }
    }
}

