/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator;

import java.util.ResourceBundle;

public class Failure {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final int severity;
    private final String section;
    private final String description;
    private final String code;

    public Failure(int severity, String section, String description) {
        this(severity, section, description, null);
    }

    public Failure(int severity, String section, String description, String code) {
        this.severity = severity;
        this.section = section;
        this.description = description;
        this.code = code;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSection() {
        return this.section;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCode() {
        return this.code;
    }

    public String asText(ResourceBundle rb) {
        StringBuilder sb = new StringBuilder();
        sb = sb.append(rb.getString("severity"));
        sb = sb.append(": ");
        sb = this.severity == 0 ? sb.append(rb.getString("severity.warn")) : sb.append(rb.getString("severity.error"));
        sb = sb.append(NEW_LINE);
        sb = sb.append(rb.getString("section"));
        sb = sb.append(": ");
        sb = sb.append(this.section);
        sb = sb.append(NEW_LINE);
        sb = sb.append(rb.getString("description"));
        sb = sb.append(": ");
        sb = sb.append(this.description);
        sb = sb.append(NEW_LINE);
        if (this.code != null) {
            sb = sb.append(rb.getString("code"));
            sb = sb.append(": ");
            sb = sb.append(this.code);
            sb = sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public String asXML(ResourceBundle rb) {
        return "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.section == null ? 0 : this.section.hashCode());
        result = 31 * result + this.severity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Failure)) {
            return false;
        }
        Failure other = (Failure)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.section == null ? other.section != null : !this.section.equals(other.section)) {
            return false;
        }
        return this.severity == other.severity;
    }

    public String toString() {
        return "Failure [severity=" + this.severity + ", section=" + this.section + ", description=" + this.description + ", code=" + this.code + "]";
    }
}

