/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class TimeOutImpl
implements TimeOut {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = Messages.getBundle(CommonBundle.class);
    protected Long blockingTimeoutMillis;
    protected Long idleTimeoutMinutes;
    protected Integer allocationRetry;
    protected Long allocationRetryWaitMillis;
    protected Integer xaResourceTimeout;

    public TimeOutImpl(Long blockingTimeoutMillis, Long idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout) throws ValidateException {
        this.blockingTimeoutMillis = blockingTimeoutMillis;
        this.idleTimeoutMinutes = idleTimeoutMinutes;
        this.allocationRetry = allocationRetry;
        this.allocationRetryWaitMillis = allocationRetryWaitMillis;
        this.xaResourceTimeout = xaResourceTimeout;
        this.partialCommonValidate();
    }

    @Override
    public Long getBlockingTimeoutMillis() {
        return this.blockingTimeoutMillis;
    }

    @Override
    public Long getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    @Override
    public Integer getAllocationRetry() {
        return this.allocationRetry;
    }

    @Override
    public Long getAllocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    @Override
    public Integer getXaResourceTimeout() {
        return this.xaResourceTimeout;
    }

    private void partialCommonValidate() throws ValidateException {
        if (this.allocationRetry != null && this.allocationRetry < 0) {
            throw new ValidateException(bundle.invalidNegative(TimeOut.Tag.ALLOCATION_RETRY.getLocalName()));
        }
        if (this.blockingTimeoutMillis != null && this.blockingTimeoutMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative(TimeOut.Tag.BLOCKING_TIMEOUT_MILLIS.getLocalName()));
        }
        if (this.allocationRetryWaitMillis != null && this.allocationRetryWaitMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative(TimeOut.Tag.ALLOCATION_RETRY_WAIT_MILLIS.getLocalName()));
        }
        if (this.idleTimeoutMinutes != null && this.idleTimeoutMinutes < 0L) {
            throw new ValidateException(bundle.invalidNegative(TimeOut.Tag.IDLE_TIMEOUT_MINUTES.getLocalName()));
        }
        if (this.xaResourceTimeout != null && this.xaResourceTimeout < 0) {
            throw new ValidateException(bundle.invalidNegative(TimeOut.Tag.XA_RESOURCE_TIMEOUT.getLocalName()));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allocationRetry == null ? 0 : this.allocationRetry.hashCode());
        result = 31 * result + (this.allocationRetryWaitMillis == null ? 0 : this.allocationRetryWaitMillis.hashCode());
        result = 31 * result + (this.blockingTimeoutMillis == null ? 0 : this.blockingTimeoutMillis.hashCode());
        result = 31 * result + (this.idleTimeoutMinutes == null ? 0 : this.idleTimeoutMinutes.hashCode());
        result = 31 * result + (this.xaResourceTimeout == null ? 0 : this.xaResourceTimeout.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeOutImpl)) {
            return false;
        }
        TimeOutImpl other = (TimeOutImpl)obj;
        if (this.allocationRetry == null ? other.allocationRetry != null : !this.allocationRetry.equals(other.allocationRetry)) {
            return false;
        }
        if (this.allocationRetryWaitMillis == null ? other.allocationRetryWaitMillis != null : !this.allocationRetryWaitMillis.equals(other.allocationRetryWaitMillis)) {
            return false;
        }
        if (this.blockingTimeoutMillis == null ? other.blockingTimeoutMillis != null : !this.blockingTimeoutMillis.equals(other.blockingTimeoutMillis)) {
            return false;
        }
        if (this.idleTimeoutMinutes == null ? other.idleTimeoutMinutes != null : !this.idleTimeoutMinutes.equals(other.idleTimeoutMinutes)) {
            return false;
        }
        return !(this.xaResourceTimeout == null ? other.xaResourceTimeout != null : !this.xaResourceTimeout.equals(other.xaResourceTimeout));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<timeout>");
        if (this.blockingTimeoutMillis != null) {
            sb.append("<").append((Object)TimeOut.Tag.BLOCKING_TIMEOUT_MILLIS).append(">");
            sb.append(this.blockingTimeoutMillis);
            sb.append("</").append((Object)TimeOut.Tag.BLOCKING_TIMEOUT_MILLIS).append(">");
        }
        if (this.idleTimeoutMinutes != null) {
            sb.append("<").append((Object)TimeOut.Tag.IDLE_TIMEOUT_MINUTES).append(">");
            sb.append(this.idleTimeoutMinutes);
            sb.append("</").append((Object)TimeOut.Tag.IDLE_TIMEOUT_MINUTES).append(">");
        }
        if (this.allocationRetry != null) {
            sb.append("<").append((Object)TimeOut.Tag.ALLOCATION_RETRY).append(">");
            sb.append(this.allocationRetry);
            sb.append("</").append((Object)TimeOut.Tag.ALLOCATION_RETRY).append(">");
        }
        if (this.allocationRetryWaitMillis != null) {
            sb.append("<").append((Object)TimeOut.Tag.ALLOCATION_RETRY_WAIT_MILLIS).append(">");
            sb.append(this.allocationRetryWaitMillis);
            sb.append("</").append((Object)TimeOut.Tag.ALLOCATION_RETRY_WAIT_MILLIS).append(">");
        }
        if (this.xaResourceTimeout != null) {
            sb.append("<").append((Object)TimeOut.Tag.XA_RESOURCE_TIMEOUT).append(">");
            sb.append(this.xaResourceTimeout);
            sb.append("</").append((Object)TimeOut.Tag.XA_RESOURCE_TIMEOUT).append(">");
        }
        sb.append("</timeout>");
        return sb.toString();
    }
}

