/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ds;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.Statement;

public interface DataSource
extends CommonDataSource {
    public Boolean isJTA();

    public String getConnectionUrl();

    public String getDriverClass();

    public String getDataSourceClass();

    public Map<String, String> getConnectionProperties();

    public Statement getStatement();

    public String getUrlDelimiter();

    public String getUrlSelectorStrategyClassName();

    public String getNewConnectionSql();

    public DsPool getPool();

    public Boolean isConnectable();

    public Boolean isTracking();

    public static enum Attribute {
        UNKNOWN(null),
        JNDI_NAME("jndi-name"),
        POOL_NAME("pool-name"),
        ENABLED("enabled"),
        USE_JAVA_CONTEXT("use-java-context"),
        SPY("spy"),
        USE_CCM("use-ccm"),
        JTA("jta"),
        CONNECTABLE("connectable"),
        TRACKING("tracking"),
        MCP("mcp"),
        ENLISTMENT_TRACE("enlistment-trace");

        private String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Attribute value(String v) {
            this.name = v;
            return this;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        POOL("pool"),
        CONNECTION_URL("connection-url"),
        DRIVER_CLASS("driver-class"),
        DATASOURCE_CLASS("datasource-class"),
        DRIVER("driver"),
        TRANSACTION_ISOLATION("transaction-isolation"),
        CONNECTION_PROPERTY("connection-property"),
        TIMEOUT("timeout"),
        SECURITY("security"),
        STATEMENT("statement"),
        VALIDATION("validation"),
        URL_DELIMITER("url-delimiter"),
        URL_SELECTOR_STRATEGY_CLASS_NAME("url-selector-strategy-class-name"),
        NEW_CONNECTION_SQL("new-connection-sql");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

