/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.dom;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataDescriptor;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataEnum;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataJavaDoc;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomWriter {
    private static final Logger log = Logger.getLogger(DomWriter.class.getName());

    public void write(Metadata metadata, String pathToMetadata, List<? extends MetadataJavaDoc> javadocTags) {
        try {
            Attr attrPackageImpl;
            Attr attrPackageApi;
            Attr attrSchemaName;
            Attr attrNamespace;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("metadata");
            doc.appendChild(rootElement);
            Element javadocsElement = doc.createElement("javadocs");
            rootElement.appendChild(javadocsElement);
            if (javadocTags != null) {
                for (MetadataJavaDoc metadataJavaDoc : javadocTags) {
                    Attr javadocName = doc.createAttribute("tag");
                    javadocName.setValue(metadataJavaDoc.getTag());
                    Attr javadocValue = doc.createAttribute("value");
                    javadocValue.setValue(metadataJavaDoc.getValue());
                    Element tagElement = doc.createElement("tag");
                    tagElement.setAttributeNode(javadocName);
                    tagElement.setAttributeNode(javadocValue);
                    javadocsElement.appendChild(tagElement);
                }
            }
            Element packages = doc.createElement("packages");
            rootElement.appendChild(packages);
            for (MetadataDescriptor descriptor : metadata.getMetadataDescriptorList()) {
                Element packageApi = doc.createElement("api");
                Attr packageApiName = doc.createAttribute("name");
                packageApiName.setValue(descriptor.getPackageApi());
                packageApi.setAttributeNode(packageApiName);
                Attr schemaNameApi = doc.createAttribute("schema");
                schemaNameApi.setValue(descriptor.getSchemaName());
                packageApi.setAttributeNode(schemaNameApi);
                Attr generateClassApi = doc.createAttribute("generateClass");
                generateClassApi.setValue(Boolean.toString(descriptor.isGenerateClasses()));
                packageApi.setAttributeNode(generateClassApi);
                packages.appendChild(packageApi);
            }
            for (MetadataDescriptor descriptor : metadata.getMetadataDescriptorList()) {
                Element packageImpl = doc.createElement("impl");
                Attr packageImplName = doc.createAttribute("name");
                packageImplName.setValue(descriptor.getPackageImpl());
                packageImpl.setAttributeNode(packageImplName);
                Attr schemaNameImpl = doc.createAttribute("schema");
                schemaNameImpl.setValue(descriptor.getSchemaName());
                packageImpl.setAttributeNode(schemaNameImpl);
                Attr generateClassImpl = doc.createAttribute("generateClass");
                generateClassImpl.setValue(Boolean.toString(descriptor.isGenerateClasses()));
                packageImpl.setAttributeNode(generateClassImpl);
                packages.appendChild(packageImpl);
            }
            Element element = doc.createElement("datatypes");
            rootElement.appendChild(element);
            for (MetadataItem metadataType : metadata.getDataTypeList()) {
                Element datatype = doc.createElement("datatype");
                Attr attrName = doc.createAttribute("name");
                attrName.setValue(metadataType.getName());
                datatype.setAttributeNode(attrName);
                Attr attrMappedTo = doc.createAttribute("mappedTo");
                attrMappedTo.setValue(metadataType.getMappedTo());
                datatype.setAttributeNode(attrMappedTo);
                attrNamespace = doc.createAttribute("namespace");
                attrNamespace.setValue(metadataType.getNamespace());
                datatype.setAttributeNode(attrNamespace);
                Attr attrSchemaName2 = doc.createAttribute("schemaName");
                attrSchemaName2.setValue(metadataType.getSchemaName());
                datatype.setAttributeNode(attrSchemaName2);
                element.appendChild(datatype);
            }
            Element enums = doc.createElement("enums");
            rootElement.appendChild(enums);
            for (MetadataEnum metadataEnum : metadata.getEnumList()) {
                Element enumElement = doc.createElement("enum");
                Attr attrName = doc.createAttribute("name");
                attrName.setValue(metadataEnum.getName());
                enumElement.setAttributeNode(attrName);
                attrNamespace = doc.createAttribute("namespace");
                attrNamespace.setValue(metadataEnum.getNamespace());
                enumElement.setAttributeNode(attrNamespace);
                Attr attrSchemaName2 = doc.createAttribute("schemaName");
                attrSchemaName2.setValue(metadataEnum.getSchemaName());
                enumElement.setAttributeNode(attrSchemaName2);
                Attr attrPackage = doc.createAttribute("package");
                attrPackage.setValue(metadataEnum.getPackageApi());
                enumElement.setAttributeNode(attrPackage);
                Attr attrDocumentation = doc.createAttribute("documentation");
                attrDocumentation.setValue("");
                enumElement.setAttributeNode(attrDocumentation);
                for (String value : metadataEnum.getValueList()) {
                    Element element2 = doc.createElement("value");
                    element2.setTextContent(value);
                    enumElement.appendChild(element2);
                }
                enums.appendChild(enumElement);
            }
            Element groups = doc.createElement("groups");
            rootElement.appendChild(groups);
            for (MetadataItem metadataClass : metadata.getGroupList()) {
                Attr elName;
                Element childElement;
                Element classElement = doc.createElement("class");
                Attr attrName = doc.createAttribute("name");
                attrName.setValue(metadataClass.getName());
                classElement.setAttributeNode(attrName);
                Attr attrNamespace2 = doc.createAttribute("namespace");
                attrNamespace2.setValue(metadataClass.getNamespace());
                classElement.setAttributeNode(attrNamespace2);
                Attr attrSchemaName3 = doc.createAttribute("schemaName");
                attrSchemaName3.setValue(metadataClass.getSchemaName());
                classElement.setAttributeNode(attrSchemaName3);
                Attr attrPackageApi2 = doc.createAttribute("package");
                attrPackageApi2.setValue(metadataClass.getPackageApi());
                classElement.setAttributeNode(attrPackageApi2);
                Attr attrDocumentation = doc.createAttribute("documentation");
                attrDocumentation.setValue("");
                classElement.setAttributeNode(attrDocumentation);
                for (MetadataElement metadataElement : metadataClass.getElements()) {
                    Attr elAttribute;
                    childElement = doc.createElement("element");
                    elName = doc.createAttribute("name");
                    elName.setValue(metadataElement.getName());
                    childElement.setAttributeNode(elName);
                    Attr elType = doc.createAttribute("type");
                    elType.setValue(metadataElement.getType());
                    childElement.setAttributeNode(elType);
                    if (metadataElement.getIsAttribute()) {
                        elAttribute = doc.createAttribute("attribute");
                        elAttribute.setValue(Boolean.toString(metadataElement.getIsAttribute()));
                        childElement.setAttributeNode(elAttribute);
                    }
                    if (metadataElement.getDefaultValue() != null) {
                        elAttribute = doc.createAttribute("default");
                        elAttribute.setValue(metadataElement.getDefaultValue());
                        childElement.setAttributeNode(elAttribute);
                    }
                    if (metadataElement.getFixedValue() != null) {
                        elAttribute = doc.createAttribute("fixed");
                        elAttribute.setValue(metadataElement.getFixedValue());
                        childElement.setAttributeNode(elAttribute);
                    }
                    if (metadataElement.getUse() != null) {
                        elAttribute = doc.createAttribute("use");
                        elAttribute.setValue(metadataElement.getUse());
                        childElement.setAttributeNode(elAttribute);
                    }
                    if (metadataElement.getMaxOccurs() != null) {
                        Attr elMaxOccurs = doc.createAttribute("maxOccurs");
                        elMaxOccurs.setValue(metadataElement.getMaxOccurs());
                        childElement.setAttributeNode(elMaxOccurs);
                    }
                    classElement.appendChild(childElement);
                }
                for (MetadataElement metadataElement : metadataClass.getReferences()) {
                    childElement = doc.createElement("include");
                    elName = doc.createAttribute("name");
                    elName.setValue(metadataElement.getRef());
                    childElement.setAttributeNode(elName);
                    classElement.appendChild(childElement);
                }
                groups.appendChild(classElement);
            }
            Element classes = doc.createElement("classes");
            rootElement.appendChild(classes);
            for (MetadataItem metadataClass : metadata.getClassList()) {
                Attr elName;
                Element childElement;
                Element classElement = doc.createElement("class");
                Attr attrName = doc.createAttribute("name");
                attrName.setValue(metadataClass.getName());
                classElement.setAttributeNode(attrName);
                Attr attrNamespace3 = doc.createAttribute("namespace");
                attrNamespace3.setValue(metadataClass.getNamespace());
                classElement.setAttributeNode(attrNamespace3);
                attrSchemaName = doc.createAttribute("schemaName");
                attrSchemaName.setValue(metadataClass.getSchemaName());
                classElement.setAttributeNode(attrSchemaName);
                attrPackageApi = doc.createAttribute("packageApi");
                attrPackageApi.setValue(metadataClass.getPackageApi());
                classElement.setAttributeNode(attrPackageApi);
                attrPackageImpl = doc.createAttribute("packageImpl");
                attrPackageImpl.setValue(metadataClass.getPackageImpl());
                classElement.setAttributeNode(attrPackageImpl);
                Attr attr = doc.createAttribute("documentation");
                attr.setValue("");
                classElement.setAttributeNode(attr);
                for (MetadataElement element3 : metadataClass.getElements()) {
                    Attr elAttribute;
                    childElement = doc.createElement("element");
                    elName = doc.createAttribute("name");
                    elName.setValue(element3.getName());
                    childElement.setAttributeNode(elName);
                    Attr elType = doc.createAttribute("type");
                    elType.setValue(element3.getType());
                    childElement.setAttributeNode(elType);
                    if (element3.getMaxOccurs() != null) {
                        Attr elMaxOccurs = doc.createAttribute("maxOccurs");
                        elMaxOccurs.setValue(element3.getMaxOccurs());
                        childElement.setAttributeNode(elMaxOccurs);
                    }
                    if (element3.getIsAttribute()) {
                        elAttribute = doc.createAttribute("attribute");
                        elAttribute.setValue(Boolean.toString(element3.getIsAttribute()));
                        childElement.setAttributeNode(elAttribute);
                    }
                    if (element3.getDefaultValue() != null) {
                        elAttribute = doc.createAttribute("default");
                        elAttribute.setValue(element3.getDefaultValue());
                        childElement.setAttributeNode(elAttribute);
                    }
                    if (element3.getFixedValue() != null) {
                        elAttribute = doc.createAttribute("fixed");
                        elAttribute.setValue(element3.getFixedValue());
                        childElement.setAttributeNode(elAttribute);
                    }
                    if (element3.getUse() != null) {
                        elAttribute = doc.createAttribute("use");
                        elAttribute.setValue(element3.getUse());
                        childElement.setAttributeNode(elAttribute);
                    }
                    classElement.appendChild(childElement);
                }
                for (MetadataElement element3 : metadataClass.getReferences()) {
                    childElement = doc.createElement("include");
                    elName = doc.createAttribute("name");
                    elName.setValue(element3.getRef());
                    childElement.setAttributeNode(elName);
                    if (element3.getMaxOccurs() != null) {
                        Attr elMaxOccurs = doc.createAttribute("maxOccurs");
                        elMaxOccurs.setValue(element3.getMaxOccurs());
                        childElement.setAttributeNode(elMaxOccurs);
                    }
                    classElement.appendChild(childElement);
                }
                classes.appendChild(classElement);
            }
            Element descriptors = doc.createElement("descriptors");
            rootElement.appendChild(descriptors);
            for (MetadataDescriptor descriptor : metadata.getMetadataDescriptorList()) {
                if (descriptor.getRootElementName() == null || descriptor.getRootElementType() == null) continue;
                Element descriptorElement = doc.createElement("descriptor");
                descriptors.appendChild(descriptorElement);
                Attr attrName = doc.createAttribute("name");
                attrName.setValue(descriptor.getName());
                descriptorElement.setAttributeNode(attrName);
                attrSchemaName = doc.createAttribute("schemaName");
                attrSchemaName.setValue(descriptor.getSchemaName());
                descriptorElement.setAttributeNode(attrSchemaName);
                attrPackageApi = doc.createAttribute("packageApi");
                attrPackageApi.setValue(descriptor.getPackageApi());
                descriptorElement.setAttributeNode(attrPackageApi);
                attrPackageImpl = doc.createAttribute("packageImpl");
                attrPackageImpl.setValue(descriptor.getPackageImpl());
                descriptorElement.setAttributeNode(attrPackageImpl);
                Element element4 = doc.createElement("element");
                descriptorElement.appendChild(element4);
                Attr attElementName = doc.createAttribute("name");
                attElementName.setValue(descriptor.getRootElementName());
                element4.setAttributeNode(attElementName);
                Attr attElementType = doc.createAttribute("type");
                attElementType.setValue(descriptor.getRootElementType());
                element4.setAttributeNode(attElementType);
                Enumeration<Object> em = descriptor.getNamespaces().keys();
                while (em.hasMoreElements()) {
                    String key = (String)em.nextElement();
                    String value = (String)descriptor.getNamespaces().get(key);
                    Attr namespaceAttrName = doc.createAttribute("name");
                    namespaceAttrName.setValue(key);
                    Attr namespaceAttrValue = doc.createAttribute("value");
                    namespaceAttrValue.setValue(value);
                    Element namespaceElement = doc.createElement("namespace");
                    namespaceElement.setAttributeNode(namespaceAttrName);
                    namespaceElement.setAttributeNode(namespaceAttrValue);
                    descriptorElement.appendChild(namespaceElement);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            File file = new File(pathToMetadata);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Saved: " + file.getAbsolutePath());
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
    }
}

