/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.awt.Dimension;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.fest.util.Arrays;
import org.fest.util.Collections;
import org.fest.util.Dates;
import org.fest.util.Maps;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToString {
    public static String toStringOf(Object o) {
        if (Arrays.isArray(o)) {
            return Arrays.format(o);
        }
        if (o instanceof Calendar) {
            return ToString.toStringOf((Calendar)o);
        }
        if (o instanceof Class) {
            return ToString.toStringOf((Class)o);
        }
        if (o instanceof Collection) {
            return ToString.toStringOf((Collection)o);
        }
        if (o instanceof Date) {
            return ToString.toStringOf((Date)o);
        }
        if (o instanceof Dimension) {
            return ToString.toStringOf((Dimension)o);
        }
        if (o instanceof File) {
            return ToString.toStringOf((File)o);
        }
        if (o instanceof Map) {
            return ToString.toStringOf((Map)o);
        }
        if (o instanceof String) {
            return Strings.quote((String)o);
        }
        return o == null ? null : o.toString();
    }

    private static String toStringOf(Calendar c) {
        return Dates.format(c);
    }

    private static String toStringOf(Class<?> c) {
        return c.getName();
    }

    private static String toStringOf(Collection<?> c) {
        return Collections.format(c);
    }

    private static String toStringOf(Date d) {
        return Dates.format(d);
    }

    private static String toStringOf(Dimension d) {
        return String.format("(w=%s, h=%s)", d.width, d.height);
    }

    private static String toStringOf(File f) {
        return f.getAbsolutePath();
    }

    private static String toStringOf(Map<?, ?> m) {
        return Maps.format(m);
    }

    private ToString() {
    }
}

