/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JPackage;
import org.jboss.jdeparser.JTypeVar;

final class JExtendsWildcard
extends JClass {
    private final JClass[] bounds;

    JExtendsWildcard(JClass ... bounds) {
        super(bounds[0].owner());
        this.bounds = bounds;
    }

    @Override
    public String name() {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("? extends ");
        for (i = 0; i < this.bounds.length - 1; ++i) {
            b.append(this.bounds[i].name()).append(" & ");
        }
        b.append(this.bounds[i].name());
        return b.toString();
    }

    @Override
    public String fullName() {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("? extends ");
        for (i = 0; i < this.bounds.length - 1; ++i) {
            b.append(this.bounds[i].fullName()).append(" & ");
        }
        b.append(this.bounds[i].fullName());
        return b.toString();
    }

    @Override
    public JPackage _package() {
        return null;
    }

    @Override
    public JClass _extends() {
        return this.bounds[0];
    }

    @Override
    public Iterator<JClass> _implements() {
        return Arrays.asList(this.bounds).subList(1, this.bounds.length).iterator();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    protected JClass substituteParams(JTypeVar[] variables, List<JClass> bindings) {
        JClass[] copiedBounds = new JClass[this.bounds.length];
        for (int i = 0; i < this.bounds.length; ++i) {
            copiedBounds[i] = this.bounds[i].substituteParams(variables, bindings);
        }
        return new JExtendsWildcard(copiedBounds);
    }

    @Override
    public void generate(JFormatter f) {
        if (this.bounds.length == 1 && this.bounds[0]._extends() == null) {
            f.p("?");
        } else {
            int i;
            f.p("? extends");
            int length = this.bounds.length;
            for (i = 0; i < length - 1; ++i) {
                f.g(this.bounds[i]);
                f.p("&");
            }
            f.g(this.bounds[i]);
        }
    }
}

