/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Map;
import org.jboss.jca.common.CommonLogger;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.XaPoolImpl;
import org.jboss.logging.Logger;

public class DsXaPoolImpl
extends XaPoolImpl
implements DsXaPool {
    private static final long serialVersionUID = 1L;
    protected final Boolean allowMultipleUsers;
    protected final Extension connectionListener;
    private static CommonLogger log = Logger.getMessageLogger(CommonLogger.class, DsXaPoolImpl.class.getName());

    public DsXaPoolImpl(Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Boolean isSameRmOverride, Boolean interleaving, Boolean padXid, Boolean wrapXaResource, Boolean noTxSeparatePool, Boolean allowMultipleUsers, Capacity capacity, Boolean fair, Extension connectionListener) throws ValidateException {
        super(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, capacity, fair, isSameRmOverride, interleaving, padXid, wrapXaResource, noTxSeparatePool);
        this.allowMultipleUsers = allowMultipleUsers;
        this.connectionListener = connectionListener;
        this.checkAllowMultipleUsersPrefill();
    }

    @Override
    public final Boolean isAllowMultipleUsers() {
        return this.allowMultipleUsers;
    }

    @Override
    public Extension getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowMultipleUsers == null ? 0 : this.allowMultipleUsers.hashCode());
        result = 31 * result + (this.connectionListener == null ? 7 : 7 * this.connectionListener.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DsXaPoolImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DsXaPoolImpl other = (DsXaPoolImpl)obj;
        if (this.allowMultipleUsers == null ? other.allowMultipleUsers != null : !this.allowMultipleUsers.equals(other.allowMultipleUsers)) {
            return false;
        }
        return !(this.connectionListener == null ? other.connectionListener != null : !this.connectionListener.equals(other.connectionListener));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<xa-pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append((Object)DsXaPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append((Object)DsXaPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append((Object)DsXaPool.Tag.INITIAL_POOL_SIZE).append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append((Object)DsXaPool.Tag.INITIAL_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append((Object)DsXaPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append((Object)DsXaPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append((Object)DsXaPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append((Object)DsXaPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append((Object)DsXaPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append((Object)DsXaPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.fair != null && !this.fair.equals(Defaults.FAIR)) {
            sb.append("<").append((Object)DsXaPool.Tag.FAIR).append(">");
            sb.append(this.fair);
            sb.append("</").append((Object)DsXaPool.Tag.FAIR).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append((Object)DsXaPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append((Object)this.flushStrategy);
            sb.append("</").append((Object)DsXaPool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.allowMultipleUsers != null && this.allowMultipleUsers.booleanValue()) {
            sb.append("<").append((Object)DsXaPool.Tag.ALLOW_MULTIPLE_USERS).append("/>");
        }
        if (this.capacity != null) {
            sb.append(this.capacity);
        }
        if (this.connectionListener != null) {
            sb.append("<").append((Object)DsXaPool.Tag.CONNECTION_LISTENER);
            sb.append(" ").append((Object)Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.connectionListener.getClassName()).append("\"");
            sb.append(">");
            if (this.connectionListener.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry<String, String> entry : this.connectionListener.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append((Object)Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append(entry.getKey()).append("\">");
                    sb.append(entry.getValue());
                    sb.append("</").append((Object)Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append((Object)DsXaPool.Tag.CONNECTION_LISTENER).append(">");
        }
        if (this.isSameRmOverride != null) {
            sb.append("<").append((Object)DsXaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
            sb.append(this.isSameRmOverride);
            sb.append("</").append((Object)DsXaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
        }
        if (this.interleaving != null && Boolean.TRUE.equals(this.interleaving)) {
            sb.append("<").append((Object)DsXaPool.Tag.INTERLEAVING).append("/>");
        }
        if (this.noTxSeparatePool != null && Boolean.TRUE.equals(this.noTxSeparatePool)) {
            sb.append("<").append((Object)DsXaPool.Tag.NO_TX_SEPARATE_POOLS).append("/>");
        }
        if (this.padXid != null) {
            sb.append("<").append((Object)DsXaPool.Tag.PAD_XID).append(">");
            sb.append(this.padXid);
            sb.append("</").append((Object)DsXaPool.Tag.PAD_XID).append(">");
        }
        if (this.wrapXaResource != null) {
            sb.append("<").append((Object)DsXaPool.Tag.WRAP_XA_RESOURCE).append(">");
            sb.append(this.wrapXaResource);
            sb.append("</").append((Object)DsXaPool.Tag.WRAP_XA_RESOURCE).append(">");
        }
        sb.append("</xa-pool>");
        return sb.toString();
    }

    private void checkAllowMultipleUsersPrefill() {
        if (this.allowMultipleUsers.booleanValue() && this.prefill.booleanValue()) {
            log.warnPrefillNotAllowedWithMultipleUsers();
        }
    }
}

