/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DataSourceAbstractImpl;

public class DataSourceImpl
extends DataSourceAbstractImpl
implements DataSource {
    private static final long serialVersionUID = 1L;
    private Boolean jta;
    private String connectionUrl;
    private String driverClass;
    private String dataSourceClass;
    private Map<String, String> connectionProperties;
    private DsPool pool;

    public DataSourceImpl(String connectionUrl, String driverClass, String dataSourceClass, String driver, TransactionIsolation transactionIsolation, Map<String, String> connectionProperties, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, String newConnectionSql, Boolean useJavaContext, String poolName, Boolean enabled, String jndiName, Boolean spy, Boolean useccm, Boolean jta, Boolean connectable, Boolean tracking, String mcp, Boolean enlistmentTrace, DsPool pool) throws ValidateException {
        super(transactionIsolation, timeOut, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useccm, driver, newConnectionSql, connectable, tracking, mcp, enlistmentTrace);
        this.jta = jta;
        this.connectionUrl = connectionUrl;
        this.driverClass = driverClass;
        this.dataSourceClass = dataSourceClass;
        if (connectionProperties != null) {
            this.connectionProperties = new HashMap<String, String>(connectionProperties.size());
            this.connectionProperties.putAll(connectionProperties);
        } else {
            this.connectionProperties = new HashMap<String, String>(0);
        }
        this.pool = pool;
        this.validate();
    }

    @Override
    public Boolean isJTA() {
        return this.jta;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getDriverClass() {
        return this.driverClass;
    }

    @Override
    public String getDataSourceClass() {
        return this.dataSourceClass;
    }

    @Override
    public Map<String, String> getConnectionProperties() {
        return Collections.unmodifiableMap(this.connectionProperties);
    }

    @Override
    public DsPool getPool() {
        return this.pool;
    }

    public void forceDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void forceDataSourceClass(String dataSourceClass) {
        this.dataSourceClass = dataSourceClass;
    }

    @Override
    public void validate() throws ValidateException {
        if (this.driverClass != null && (this.connectionUrl == null || this.connectionUrl.trim().length() == 0)) {
            throw new ValidateException(bundle.requiredElementMissing(DataSource.Tag.CONNECTION_URL.getLocalName(), this.getClass().getCanonicalName()));
        }
        if (!(this.driverClass != null && this.driverClass.trim().length() != 0 || this.dataSourceClass != null && this.dataSourceClass.trim().length() != 0 || this.driver != null && this.driver.trim().length() != 0)) {
            throw new ValidateException(bundle.requiredElementMissing(DataSource.Tag.DRIVER_CLASS.getLocalName(), this.getClass().getCanonicalName()));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.jta == null ? 0 : this.jta.hashCode());
        result = 31 * result + (this.connectionUrl == null ? 0 : this.connectionUrl.hashCode());
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.dataSourceClass == null ? 0 : this.dataSourceClass.hashCode());
        result = 31 * result + (this.connectionProperties == null ? 0 : this.connectionProperties.hashCode());
        result = 31 * result + (this.pool == null ? 0 : this.pool.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataSourceImpl)) {
            return false;
        }
        DataSourceImpl other = (DataSourceImpl)obj;
        if (this.jta == null ? other.jta != null : !this.jta.equals(other.jta)) {
            return false;
        }
        if (this.connectionUrl == null ? other.connectionUrl != null : !this.connectionUrl.equals(other.connectionUrl)) {
            return false;
        }
        if (this.driverClass == null ? other.driverClass != null : !this.driverClass.equals(other.driverClass)) {
            return false;
        }
        if (this.dataSourceClass == null ? other.dataSourceClass != null : !this.dataSourceClass.equals(other.dataSourceClass)) {
            return false;
        }
        if (this.connectionProperties == null ? other.connectionProperties != null : !this.connectionProperties.equals(other.connectionProperties)) {
            return false;
        }
        return !(this.pool == null ? other.pool != null : !this.pool.equals(other.pool));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<datasource");
        if (this.jndiName != null) {
            sb.append(" ").append((Object)DataSource.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append((Object)DataSource.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append((Object)DataSource.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append((Object)DataSource.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.spy != null) {
            sb.append(" ").append((Object)DataSource.Attribute.SPY).append("=\"").append(this.spy).append("\"");
        }
        if (this.useCcm != null) {
            sb.append(" ").append((Object)DataSource.Attribute.USE_CCM).append("=\"").append(this.useCcm).append("\"");
        }
        if (this.jta != null) {
            sb.append(" ").append((Object)DataSource.Attribute.JTA).append("=\"").append(this.jta).append("\"");
        }
        if (this.connectable != null) {
            sb.append(" ").append((Object)DataSource.Attribute.CONNECTABLE).append("=\"").append(this.connectable).append("\"");
        }
        if (this.tracking != null) {
            sb.append(" ").append((Object)DataSource.Attribute.TRACKING).append("=\"").append(this.tracking).append("\"");
        }
        if (this.mcp != null) {
            sb.append(" ").append((Object)DataSource.Attribute.MCP).append("=\"").append(this.mcp).append("\"");
        }
        if (this.enlistmentTrace != null) {
            sb.append(" ").append((Object)DataSource.Attribute.ENLISTMENT_TRACE).append("=\"").append(this.enlistmentTrace).append("\"");
        }
        sb.append(">");
        if (this.connectionUrl != null) {
            sb.append("<").append((Object)DataSource.Tag.CONNECTION_URL).append(">");
            sb.append(this.connectionUrl);
            sb.append("</").append((Object)DataSource.Tag.CONNECTION_URL).append(">");
        }
        if (this.driverClass != null) {
            sb.append("<").append((Object)DataSource.Tag.DRIVER_CLASS).append(">");
            sb.append(this.driverClass);
            sb.append("</").append((Object)DataSource.Tag.DRIVER_CLASS).append(">");
        }
        if (this.dataSourceClass != null) {
            sb.append("<").append((Object)DataSource.Tag.DATASOURCE_CLASS).append(">");
            sb.append(this.dataSourceClass);
            sb.append("</").append((Object)DataSource.Tag.DATASOURCE_CLASS).append(">");
        }
        if (this.driver != null) {
            sb.append("<").append((Object)DataSource.Tag.DRIVER).append(">");
            sb.append(this.driver);
            sb.append("</").append((Object)DataSource.Tag.DRIVER).append(">");
        }
        if (this.connectionProperties != null && this.connectionProperties.size() > 0) {
            for (Map.Entry<String, String> entry : this.connectionProperties.entrySet()) {
                sb.append("<").append((Object)DataSource.Tag.CONNECTION_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append((Object)DataSource.Tag.CONNECTION_PROPERTY).append(">");
            }
        }
        if (this.newConnectionSql != null) {
            sb.append("<").append((Object)DataSource.Tag.NEW_CONNECTION_SQL).append(">");
            sb.append(this.newConnectionSql);
            sb.append("</").append((Object)DataSource.Tag.NEW_CONNECTION_SQL).append(">");
        }
        if (this.transactionIsolation != null) {
            sb.append("<").append((Object)DataSource.Tag.TRANSACTION_ISOLATION).append(">");
            sb.append(this.transactionIsolation);
            sb.append("</").append((Object)DataSource.Tag.TRANSACTION_ISOLATION).append(">");
        }
        if (this.urlDelimiter != null) {
            sb.append("<").append((Object)DataSource.Tag.URL_DELIMITER).append(">");
            sb.append(this.urlDelimiter);
            sb.append("</").append((Object)DataSource.Tag.URL_DELIMITER).append(">");
        }
        if (this.urlSelectorStrategyClassName != null) {
            sb.append("<").append((Object)DataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
            sb.append(this.urlSelectorStrategyClassName);
            sb.append("</").append((Object)DataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
        }
        if (this.pool != null) {
            sb.append(this.pool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.timeOut != null) {
            sb.append(this.timeOut);
        }
        if (this.statement != null) {
            sb.append(this.statement);
        }
        sb.append("</datasource>");
        return sb.toString();
    }
}

