/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.filter;

import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataUtil;
import org.jboss.shrinkwrap.descriptor.metadata.filter.Filter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdElementEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class AttributeFilter
implements Filter {
    /*
     * Enabled aggressive block sorting
     */
    public boolean filter(Metadata metadata, TreeWalker walker) {
        Node parentNodeWithName;
        Node parent = walker.getCurrentNode();
        Element element = (Element)parent;
        if (!XsdElementEnum.attribute.isTagNameEqual(element.getTagName()) || (parentNodeWithName = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "name")) == null) return false;
        Element parentElementWithName = (Element)parentNodeWithName;
        String groupOrClassName = MetadataUtil.getAttributeValue(parentElementWithName, "name");
        if (groupOrClassName != null) {
            String ref = MetadataUtil.getAttributeValue(element, "ref");
            if (XsdElementEnum.group.isTagNameEqual(parentElementWithName.getTagName()) || XsdElementEnum.attributeGroup.isTagNameEqual(parentElementWithName.getTagName())) {
                if (ref != null) {
                    for (MetadataItem dataType : metadata.getDataTypeList()) {
                        if (!dataType.getName().equals(ref)) continue;
                        MetadataElement classElement = new MetadataElement();
                        classElement.setName(ref);
                        classElement.setType(dataType.getMappedTo());
                        classElement.setIsAttribute(true);
                        metadata.addClassElement(groupOrClassName, classElement);
                        return true;
                    }
                    return false;
                } else {
                    MetadataElement groupElement = new MetadataElement(element);
                    String type = MetadataUtil.getAttributeValue(element, "type");
                    if (type == null) {
                        groupElement.setType("xsd:string");
                    }
                    groupElement.setIsAttribute(true);
                    metadata.addGroupElement(groupOrClassName, groupElement);
                    return true;
                }
            }
            if (ref != null) {
                for (MetadataItem dataType : metadata.getDataTypeList()) {
                    if (!dataType.getName().equals(ref)) continue;
                    MetadataElement classElement = new MetadataElement();
                    classElement.setName(ref);
                    classElement.setType(dataType.getMappedTo());
                    classElement.setIsAttribute(true);
                    metadata.addClassElement(groupOrClassName, classElement);
                    return true;
                }
                return false;
            } else {
                Node node = element.getAttributes().getNamedItem("type");
                if (node == null) return false;
                boolean isTextOnlyElement = MetadataUtil.hasParentOf(element, XsdElementEnum.simpleContent);
                if (node.getNodeValue().endsWith(":ID") && isTextOnlyElement) {
                    return false;
                }
                MetadataElement classElement = new MetadataElement(element);
                String type = MetadataUtil.getAttributeValue(element, "type");
                if (type == null) {
                    classElement.setType("xsd:string");
                }
                classElement.setIsAttribute(true);
                metadata.addClassElement(groupOrClassName, classElement);
                return true;
            }
        }
        Element rootElement = (Element)parentNodeWithName;
        if (!XsdElementEnum.schema.isTagNameEqual(rootElement.getTagName())) return false;
        String attrName = MetadataUtil.getAttributeValue(element, "name");
        String type = MetadataUtil.getAttributeValue(element, "type");
        MetadataItem dataType = new MetadataItem(attrName);
        dataType.setMappedTo(type);
        if (type == null) {
            dataType.setMappedTo("xsd:string");
        }
        dataType.setNamespace(metadata.getCurrentNamespace());
        dataType.setSchemaName(metadata.getCurrentSchmema());
        metadata.getDataTypeList().add(dataType);
        return true;
    }
}

