/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.logging.processor.apt.AbstractGenerator;
import org.jboss.logging.processor.apt.Annotations;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelFactory;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.TranslationHelper;
import org.jboss.logging.processor.validation.FormatValidator;
import org.jboss.logging.processor.validation.FormatValidatorFactory;
import org.jboss.logging.processor.validation.StringFormatValidator;

@SupportedOptions(value={"translationFilesPath", "skipTranslations"})
final class TranslationClassGenerator
extends AbstractGenerator {
    public static final String TRANSLATION_FILES_PATH_OPTION = "translationFilesPath";
    public static final String SKIP_TRANSLATIONS = "skipTranslations";
    private static final String TRANSLATION_FILE_EXTENSION_PATTERN = ".i18n_[a-z]*(_[A-Z]*){0,2}\\.properties";
    private final String translationFilesPath;
    private final boolean skipTranslations;

    public TranslationClassGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        this.translationFilesPath = options.get(TRANSLATION_FILES_PATH_OPTION);
        String value = options.get(SKIP_TRANSLATIONS);
        this.skipTranslations = options.containsKey(SKIP_TRANSLATIONS) && (value == null || Boolean.valueOf(value) != false);
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, MessageInterface messageInterface) {
        if (this.skipTranslations) {
            this.logger().debug(element, "Skipping processing of translation implementation");
            return;
        }
        try {
            List<File> files = this.findTranslationFiles(messageInterface);
            Map<File, Map<MessageMethod, String>> validTranslations = this.allInterfaceTranslations(messageInterface, files);
            if (files != null) {
                for (File file : files) {
                    this.generateSourceFileFor(messageInterface, file, validTranslations.get(file));
                }
            }
        }
        catch (IOException e) {
            this.logger().error((Throwable)e, "Cannot read %s package files", messageInterface.packageName());
        }
    }

    private Map<File, Map<MessageMethod, String>> allInterfaceTranslations(MessageInterface messageInterface, List<File> files) throws IOException {
        HashMap<File, Map<MessageMethod, String>> validTranslations = new HashMap<File, Map<MessageMethod, String>>();
        for (MessageInterface superInterface : messageInterface.extendedInterfaces()) {
            validTranslations.putAll(this.allInterfaceTranslations(superInterface, this.findTranslationFiles(superInterface)));
        }
        if (files != null) {
            for (File file : files) {
                validTranslations.put(file, this.validateTranslationMessages(messageInterface, file));
            }
        }
        return validTranslations;
    }

    private List<File> findTranslationFiles(MessageInterface messageInterface) throws IOException {
        List<File> result;
        String classTranslationFilesPath;
        String packageName = messageInterface.packageName();
        String interfaceName = messageInterface.simpleName();
        if (this.translationFilesPath != null) {
            classTranslationFilesPath = this.translationFilesPath + packageName.replace('.', File.separatorChar);
        } else {
            FileObject fObj = this.filer().getResource(StandardLocation.CLASS_OUTPUT, packageName, interfaceName);
            classTranslationFilesPath = fObj.toUri().getPath().replace(interfaceName, "");
        }
        File[] files = new File(classTranslationFilesPath).listFiles(new TranslationFileFilter(interfaceName));
        if (files == null) {
            result = Collections.emptyList();
        } else {
            result = Arrays.asList(files);
            Collections.sort(result, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    int result = o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                    result = result != 0 ? result : Integer.signum(o1.getName().length() - o2.getName().length());
                    return result;
                }
            });
        }
        return result;
    }

    private Map<MessageMethod, String> validateTranslationMessages(MessageInterface messageInterface, File file) {
        HashMap<MessageMethod, String> validTranslations = new HashMap<MessageMethod, String>();
        try {
            Properties translations = new Properties();
            translations.load(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            HashSet<MessageMethod> messageMethods = new HashSet<MessageMethod>();
            messageMethods.addAll(messageInterface.methods());
            for (MessageInterface msgIntf : messageInterface.extendedInterfaces()) {
                if (msgIntf.isLoggerInterface()) continue;
                messageMethods.addAll(msgIntf.methods());
            }
            for (MessageMethod messageMethod : messageMethods) {
                String key = messageMethod.translationKey();
                Element methodElement = ElementHelper.fromMessageObject(messageMethod);
                if (translations.containsKey(key)) {
                    String translationMessage = translations.getProperty(key);
                    if (!translationMessage.trim().isEmpty()) {
                        FormatValidator validator = TranslationClassGenerator.getValidatorFor(messageMethod, translationMessage);
                        if (validator.isValid()) {
                            if (validator.argumentCount() == messageMethod.formatParameterCount()) {
                                validTranslations.put(messageMethod, translationMessage);
                                continue;
                            }
                            this.logger().warn(methodElement, "The parameter count for the format (%d) and the number of format parameters (%d) do not match.", validator.argumentCount(), messageMethod.formatParameterCount());
                            continue;
                        }
                        this.logger().warn(methodElement, "%s Resource Bundle: %s", validator.summaryMessage(), file.getAbsolutePath());
                        continue;
                    }
                    this.logger().warn(methodElement, "The translation message with key %s is ignored because value is empty or contains only whitespace", key);
                    continue;
                }
                this.logger().warn(methodElement, "The translation message with key %s have no corresponding messageMethod.", key);
            }
        }
        catch (IOException e) {
            this.logger().error((Throwable)e, "Cannot read the %s translation file", file.getName());
        }
        return validTranslations;
    }

    private void generateSourceFileFor(MessageInterface messageInterface, File translationFile, Map<MessageMethod, String> translations) {
        this.logger().note(ElementHelper.fromMessageObject(messageInterface), "Generating translation class.");
        String enclosingTranslationFileName = TranslationHelper.getEnclosingTranslationFileName(translationFile);
        File enclosingTranslationFile = new File(translationFile.getParent(), enclosingTranslationFileName);
        if (!enclosingTranslationFileName.equals(translationFile.getName()) && !enclosingTranslationFile.exists()) {
            this.generateSourceFileFor(messageInterface, enclosingTranslationFile, Collections.<MessageMethod, String>emptyMap());
        }
        ClassModel classModel = ClassModelFactory.translation(messageInterface, TranslationHelper.getTranslationClassNameSuffix(translationFile.getName()), translations);
        try {
            classModel.create(this.filer().createSourceFile(classModel.qualifiedClassName(), new Element[0]));
        }
        catch (IOException ex) {
            this.logger().error((Throwable)ex, "Cannot generate %s source file", classModel.qualifiedClassName());
        }
        catch (IllegalStateException ex) {
            this.logger().error((Throwable)ex, "Cannot generate %s source file", classModel.qualifiedClassName());
        }
    }

    private static FormatValidator getValidatorFor(MessageMethod messageMethod, String translationMessage) {
        FormatValidator result = FormatValidatorFactory.create(messageMethod.message().format(), translationMessage);
        if (result.isValid() && messageMethod.message().format() == Annotations.FormatType.PRINTF) {
            result = StringFormatValidator.withTranslation(messageMethod.message().value(), translationMessage);
        }
        return result;
    }

    private class TranslationFileFilter
    implements FilenameFilter {
        private final String className;

        public TranslationFileFilter(String className) {
            this.className = className;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean isGenerated = name.endsWith(".i18n_locale_COUNTRY_VARIANT.properties");
            boolean isTranslationFile = name.matches(Pattern.quote(this.className) + TranslationClassGenerator.TRANSLATION_FILE_EXTENSION_PATTERN);
            return !isGenerated && isTranslationFile;
        }
    }
}

