/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser.writer;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.jdeparser.CodeWriter;
import org.jboss.jdeparser.JPackage;

public class ZipCodeWriter
extends CodeWriter {
    private final ZipOutputStream zip;
    private final OutputStream filter;

    public ZipCodeWriter(OutputStream target) {
        this.zip = new ZipOutputStream(target);
        this.filter = new FilterOutputStream(this.zip){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        String name = fileName;
        if (!pkg.isUnnamed()) {
            name = ZipCodeWriter.toDirName(pkg) + name;
        }
        this.zip.putNextEntry(new ZipEntry(name));
        return this.filter;
    }

    private static String toDirName(JPackage pkg) {
        return pkg.name().replace('.', '/') + '/';
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }
}

