/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharAssert
extends GenericAssert<CharAssert, Character> {
    protected CharAssert(char actual) {
        super(CharAssert.class, Character.valueOf(actual));
    }

    protected CharAssert(Character actual) {
        super(CharAssert.class, actual);
    }

    @Override
    public CharAssert isEqualTo(char expected) {
        return (CharAssert)this.isEqualTo(Character.valueOf(expected));
    }

    @Override
    public CharAssert isNotEqualTo(char other) {
        return (CharAssert)this.isNotEqualTo(Character.valueOf(other));
    }

    public CharAssert isGreaterThan(char other) {
        if (((Character)this.actual).charValue() > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, Character.valueOf(other)));
    }

    public CharAssert isLessThan(char other) {
        if (((Character)this.actual).charValue() < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, Character.valueOf(other)));
    }

    public CharAssert isGreaterThanOrEqualTo(char other) {
        if (((Character)this.actual).charValue() >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, Character.valueOf(other)));
    }

    public CharAssert isLessThanOrEqualTo(char other) {
        if (((Character)this.actual).charValue() <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, Character.valueOf(other)));
    }

    public CharAssert isUpperCase() {
        if (Character.isUpperCase(((Character)this.actual).charValue())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(String.format("<%s> should be an upper-case character", this.actual));
    }

    public CharAssert isLowerCase() {
        if (Character.isLowerCase(((Character)this.actual).charValue())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(String.format("<%s> should be a lower-case character", this.actual));
    }
}

