/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.filter;

import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataUtil;
import org.jboss.shrinkwrap.descriptor.metadata.filter.Filter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdDatatypeEnum;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdElementEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class UnionFilter
implements Filter {
    public boolean filter(Metadata metadata, TreeWalker walker) {
        Node parentNodeWithName;
        String memberTypesStr;
        Node parent = walker.getCurrentNode();
        Element element = (Element)parent;
        if (XsdElementEnum.union.isTagNameEqual(element.getTagName()) && (memberTypesStr = MetadataUtil.getAttributeValue(element, "memberTypes")) != null && (parentNodeWithName = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "name")) != null) {
            Element parentElementWithName = (Element)parentNodeWithName;
            String parentName = MetadataUtil.getAttributeValue(parentElementWithName, "name");
            String[] items = memberTypesStr.split(" ", -1);
            if (items != null && items.length > 1) {
                MetadataItem dataType = new MetadataItem(parentName);
                dataType.setMappedTo(this.getDataType(items));
                dataType.setNamespace(metadata.getCurrentNamespace());
                dataType.setSchemaName(metadata.getCurrentSchmema());
                metadata.getDataTypeList().add(dataType);
            }
        }
        return false;
    }

    private String getDataType(String[] items) {
        for (String item : items) {
            if (!XsdDatatypeEnum.ENTITIES.isDataType(item)) continue;
            return item;
        }
        return items[0];
    }
}

