/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.filter;

import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataUtil;
import org.jboss.shrinkwrap.descriptor.metadata.filter.Filter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdElementEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class EnumFilter
implements Filter {
    public boolean filter(Metadata metadata, TreeWalker walker) {
        Node valueNode;
        Node parent = walker.getCurrentNode();
        Element element = (Element)parent;
        if (XsdElementEnum.enumeration.isTagNameEqual(element.getTagName()) && (valueNode = element.getAttributes().getNamedItem("value")) != null) {
            String enumValue = valueNode.getNodeValue();
            Node simpleTypeNode = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "name");
            if (simpleTypeNode != null) {
                Element parentElementWithName = (Element)simpleTypeNode;
                String enumName = MetadataUtil.getAttributeValue(parentElementWithName, "name");
                metadata.addEnumValue(enumName, enumValue);
                return true;
            }
        }
        return false;
    }
}

