/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.spec.AuthenticationMechanism;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.Icon;
import org.jboss.jca.common.api.metadata.spec.LicenseType;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.MergeableMetadata;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.SecurityPermission;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.spec.XML;
import org.jboss.logging.Messages;

public class ConnectorImpl
implements Connector {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = Messages.getBundle(CommonBundle.class);
    private Connector.Version version;
    private XsdString moduleName;
    private List<XsdString> requiredWorkContexts;
    private boolean metadataComplete;
    private XsdString resourceadapterVersion;
    private XsdString vendorName;
    private XsdString eisType;
    private LicenseType license;
    private ResourceAdapter resourceadapter;
    private String id;
    private List<LocalizedXsdString> description;
    private List<LocalizedXsdString> displayName;
    private List<Icon> icon;

    public ConnectorImpl(Connector.Version version, XsdString moduleName, XsdString vendorName, XsdString eisType, XsdString resourceadapterVersion, LicenseType license, ResourceAdapter resourceadapter, List<XsdString> requiredWorkContexts, boolean metadataComplete, List<LocalizedXsdString> description, List<LocalizedXsdString> displayNames, List<Icon> icons, String id) {
        this.version = version;
        this.moduleName = moduleName;
        if (!XsdString.isNull(this.moduleName)) {
            this.moduleName.setTag(XML.Connector17Tag.MODULE_NAME.toString());
        }
        if (requiredWorkContexts != null) {
            this.requiredWorkContexts = new ArrayList<XsdString>(requiredWorkContexts);
            for (XsdString wc : this.requiredWorkContexts) {
                wc.setTag(XML.Connector17Tag.REQUIRED_WORK_CONTEXT.toString());
            }
        } else {
            this.requiredWorkContexts = new ArrayList<XsdString>(0);
        }
        this.metadataComplete = metadataComplete;
        this.resourceadapterVersion = resourceadapterVersion;
        if (!XsdString.isNull(this.resourceadapterVersion)) {
            if (version == Connector.Version.V_10) {
                this.resourceadapterVersion.setTag(XML.Connector10Tag.VERSION.toString());
            } else {
                this.resourceadapterVersion.setTag(XML.Connector17Tag.RESOURCEADAPTER_VERSION.toString());
            }
        }
        this.vendorName = vendorName;
        if (!XsdString.isNull(this.vendorName)) {
            this.vendorName.setTag(XML.Connector17Tag.VENDOR_NAME.toString());
        }
        this.eisType = eisType;
        if (!XsdString.isNull(this.eisType)) {
            this.eisType.setTag(XML.Connector17Tag.EIS_TYPE.toString());
        }
        this.license = license;
        this.resourceadapter = resourceadapter;
        this.id = id;
        if (description != null) {
            this.description = new ArrayList<LocalizedXsdString>(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag(XML.Connector17Tag.DESCRIPTION.toString());
            }
        } else {
            this.description = new ArrayList<LocalizedXsdString>(0);
        }
        if (displayNames != null) {
            this.displayName = new ArrayList<LocalizedXsdString>(displayNames);
            for (LocalizedXsdString d : this.displayName) {
                d.setTag(XML.Connector17Tag.DISPLAY_NAME.toString());
            }
        } else {
            this.displayName = new ArrayList<LocalizedXsdString>(0);
        }
        this.icon = icons != null ? new ArrayList<Icon>(icons) : new ArrayList<Icon>(0);
    }

    @Override
    public XsdString getVendorName() {
        return this.vendorName;
    }

    @Override
    public XsdString getEisType() {
        return this.eisType;
    }

    @Override
    public LicenseType getLicense() {
        return this.license;
    }

    @Override
    public ResourceAdapter getResourceadapter() {
        return this.resourceadapter;
    }

    @Override
    public List<LocalizedXsdString> getDescriptions() {
        return Collections.unmodifiableList(this.description);
    }

    @Override
    public List<LocalizedXsdString> getDisplayNames() {
        return Collections.unmodifiableList(this.displayName);
    }

    @Override
    public List<Icon> getIcons() {
        return Collections.unmodifiableList(this.icon);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public XsdString getResourceadapterVersion() {
        return this.resourceadapterVersion;
    }

    @Override
    public List<String> getRequiredWorkContexts() {
        ArrayList<String> result = new ArrayList<String>(this.requiredWorkContexts.size());
        for (XsdString wc : this.requiredWorkContexts) {
            result.add(wc.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getModuleName() {
        if (XsdString.isNull(this.moduleName)) {
            return null;
        }
        return this.moduleName.getValue();
    }

    @Override
    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    @Override
    public Connector.Version getVersion() {
        return this.version;
    }

    @Override
    public Connector merge(MergeableMetadata<?> inputMd) throws Exception {
        if (inputMd instanceof ConnectorImpl) {
            ConnectorImpl input = (ConnectorImpl)inputMd;
            XsdString newResourceadapterVersion = XsdString.isNull(this.resourceadapterVersion) ? input.resourceadapterVersion : this.resourceadapterVersion;
            XsdString newEisType = XsdString.isNull(this.eisType) ? input.eisType : this.eisType;
            List<XsdString> newRequiredWorkContexts = MergeUtil.mergeList(this.requiredWorkContexts, input.requiredWorkContexts);
            XsdString newModuleName = this.moduleName == null ? input.moduleName : this.moduleName;
            List<Icon> newIcons = MergeUtil.mergeList(this.icon, input.icon);
            boolean newMetadataComplete = this.metadataComplete || input.metadataComplete;
            LicenseType newLicense = this.license == null ? input.license : (LicenseType)this.license.merge(input.license);
            List<LocalizedXsdString> newDescriptions = MergeUtil.mergeList(this.description, input.description);
            List<LocalizedXsdString> newDisplayNames = MergeUtil.mergeList(this.displayName, input.displayName);
            XsdString newVendorName = XsdString.isNull(this.vendorName) ? input.vendorName : this.vendorName;
            ResourceAdapter newResourceadapter = this.resourceadapter == null ? input.resourceadapter : (ResourceAdapter)this.resourceadapter.merge(input.resourceadapter);
            return new ConnectorImpl(this.version, newModuleName, newVendorName, newEisType, newResourceadapterVersion, newLicense, newResourceadapter, newRequiredWorkContexts, newMetadataComplete, newDescriptions, newDisplayNames, newIcons, null);
        }
        return this;
    }

    @Override
    public CopyableMetaData copy() {
        XsdString newResourceadapterVersion = CopyUtil.clone(this.resourceadapterVersion);
        XsdString newEisType = XsdString.isNull(this.eisType) ? null : (XsdString)this.eisType.copy();
        List<XsdString> newRequiredWorkContexts = CopyUtil.cloneList(this.requiredWorkContexts);
        XsdString newModuleName = CopyUtil.clone(this.moduleName);
        List<Icon> newIcons = CopyUtil.cloneList(this.icon);
        boolean newMetadataComplete = this.metadataComplete;
        LicenseType newLicense = CopyUtil.clone(this.license);
        List<LocalizedXsdString> newDescriptions = CopyUtil.cloneList(this.description);
        List<LocalizedXsdString> newDisplayNames = CopyUtil.cloneList(this.displayName);
        XsdString newVendorName = CopyUtil.clone(this.vendorName);
        ResourceAdapter newResourceadapter = CopyUtil.clone(this.resourceadapter);
        return new ConnectorImpl(this.version, newModuleName, newVendorName, newEisType, newResourceadapterVersion, newLicense, newResourceadapter, newRequiredWorkContexts, newMetadataComplete, newDescriptions, newDisplayNames, newIcons, CopyUtil.cloneString(this.id));
    }

    @Override
    public void validate() throws ValidateException {
        ResourceAdapter ra = this.getResourceadapter();
        if (ra == null) {
            throw new ValidateException(bundle.noMetadataForResourceAdapter());
        }
        ra.validate();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eisType == null ? 0 : this.eisType.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.license == null ? 0 : this.license.hashCode());
        result = 31 * result + (this.resourceadapter == null ? 0 : this.resourceadapter.hashCode());
        result = 31 * result + (this.vendorName == null ? 0 : this.vendorName.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.resourceadapterVersion == null ? 0 : this.resourceadapterVersion.hashCode());
        result = 31 * result + (this.metadataComplete ? 1231 : 1237);
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = 31 * result + (this.requiredWorkContexts == null ? 0 : this.requiredWorkContexts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorImpl)) {
            return false;
        }
        ConnectorImpl other = (ConnectorImpl)obj;
        if (this.eisType == null ? other.eisType != null : !this.eisType.equals(other.eisType)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.license == null ? other.license != null : !this.license.equals(other.license)) {
            return false;
        }
        if (this.resourceadapter == null ? other.resourceadapter != null : !this.resourceadapter.equals(other.resourceadapter)) {
            return false;
        }
        if (this.vendorName == null ? other.vendorName != null : !this.vendorName.equals(other.vendorName)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.resourceadapterVersion == null ? other.resourceadapterVersion != null : !this.resourceadapterVersion.equals(other.resourceadapterVersion)) {
            return false;
        }
        if (this.metadataComplete != other.metadataComplete) {
            return false;
        }
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
            return false;
        }
        return !(this.requiredWorkContexts == null ? other.requiredWorkContexts != null : !this.requiredWorkContexts.equals(other.requiredWorkContexts));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.version == Connector.Version.V_10) {
            sb.append("<").append("connector");
            if (this.id != null) {
                sb.append(" id=\"" + this.id + "\"");
            }
            sb.append(">");
            for (LocalizedXsdString localizedXsdString : this.displayName) {
                sb.append(localizedXsdString);
            }
            for (LocalizedXsdString localizedXsdString : this.description) {
                sb.append(localizedXsdString);
            }
            for (Icon icon : this.icon) {
                sb.append(icon);
            }
            if (!XsdString.isNull(this.vendorName)) {
                sb.append(this.vendorName);
            }
            sb.append("<").append((Object)XML.Connector10Tag.SPEC_VERSION).append(">");
            sb.append("1.0");
            sb.append("</").append((Object)XML.Connector10Tag.SPEC_VERSION).append(">");
            if (!XsdString.isNull(this.eisType)) {
                sb.append(this.eisType);
            }
            if (!XsdString.isNull(this.resourceadapterVersion)) {
                sb.append(this.resourceadapterVersion);
            }
            if (this.license != null) {
                sb.append(this.license);
            }
            sb.append("<").append((Object)XML.Connector10Tag.RESOURCEADAPTER);
            if (this.resourceadapter.getId() != null) {
                sb.append(" id=\"" + this.resourceadapter.getId() + "\"");
            }
            sb.append(">");
            ConnectionDefinition cd = this.resourceadapter.getOutboundResourceadapter().getConnectionDefinitions().get(0);
            sb.append(cd.getManagedConnectionFactoryClass());
            sb.append(cd.getConnectionFactoryInterface());
            sb.append(cd.getConnectionFactoryImplClass());
            sb.append(cd.getConnectionInterface());
            sb.append(cd.getConnectionImplClass());
            sb.append(cd.getConnectionImplClass());
            sb.append("<").append((Object)XML.ResourceAdapter10Tag.TRANSACTION_SUPPORT);
            if (this.resourceadapter.getOutboundResourceadapter().getTransactionSupportId() != null) {
                sb.append(" id=\"" + this.resourceadapter.getOutboundResourceadapter().getTransactionSupportId() + "\"");
            }
            sb.append(">");
            sb.append((Object)this.resourceadapter.getOutboundResourceadapter().getTransactionSupport());
            sb.append("</").append((Object)XML.ResourceAdapter10Tag.TRANSACTION_SUPPORT).append(">");
            for (ConfigProperty cp : cd.getConfigProperties()) {
                sb.append(cp);
            }
            for (AuthenticationMechanism am : this.resourceadapter.getOutboundResourceadapter().getAuthenticationMechanisms()) {
                sb.append(am);
            }
            sb.append("<").append((Object)XML.ResourceAdapter10Tag.REAUTHENTICATION_SUPPORT);
            if (this.resourceadapter.getOutboundResourceadapter().getReauthenticationSupportId() != null) {
                sb.append(" id=\"" + this.resourceadapter.getOutboundResourceadapter().getReauthenticationSupportId() + "\"");
            }
            sb.append(">");
            sb.append(this.resourceadapter.getOutboundResourceadapter().getReauthenticationSupport());
            sb.append("</").append((Object)XML.ResourceAdapter10Tag.REAUTHENTICATION_SUPPORT).append(">");
            for (SecurityPermission sp : this.resourceadapter.getSecurityPermissions()) {
                sb.append(sp);
            }
            sb.append("</").append((Object)XML.Connector10Tag.RESOURCEADAPTER).append(">");
        } else {
            sb.append("<").append("connector");
            sb.append(" " + String.valueOf((Object)XML.Connector17Attribute.VERSION) + "=\"" + String.valueOf((Object)this.version) + "\"");
            if (this.version == Connector.Version.V_16 || this.version == Connector.Version.V_17 || this.version == Connector.Version.V_20 || this.version == Connector.Version.V_21) {
                sb.append(" " + String.valueOf((Object)XML.Connector17Attribute.METADATA_COMPLETE) + "=\"" + this.metadataComplete + "\"");
            }
            if (this.id != null) {
                sb.append(" id=\"" + this.id + "\"");
            }
            sb.append(">");
            if (!XsdString.isNull(this.moduleName)) {
                sb.append(this.moduleName);
            }
            for (LocalizedXsdString localizedXsdString : this.description) {
                sb.append(localizedXsdString);
            }
            for (LocalizedXsdString localizedXsdString : this.displayName) {
                sb.append(localizedXsdString);
            }
            for (Icon icon : this.icon) {
                sb.append(icon);
            }
            if (!XsdString.isNull(this.vendorName)) {
                sb.append(this.vendorName);
            }
            if (!XsdString.isNull(this.eisType)) {
                sb.append(this.eisType);
            }
            if (!XsdString.isNull(this.resourceadapterVersion)) {
                sb.append(this.resourceadapterVersion);
            }
            if (this.license != null) {
                sb.append(this.license);
            }
            sb.append(this.resourceadapter);
            if (this.requiredWorkContexts != null) {
                for (XsdString xsdString : this.requiredWorkContexts) {
                    sb.append(xsdString);
                }
            }
        }
        sb.append("</").append("connector").append(">");
        return sb.toString();
    }
}

