/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.resourceadapter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.common.XaPool;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;

public class ConnectionDefinitionImpl
implements ConnectionDefinition {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> configProperties;
    protected String className;
    protected String jndiName;
    protected String poolName;
    protected Boolean enabled;
    protected Boolean useJavaContext;
    protected Boolean useCcm;
    protected Pool pool;
    protected TimeOut timeOut;
    protected Validation validation;
    protected Security security;
    protected Recovery recovery;
    protected Boolean isXA;
    protected Boolean sharable;
    protected Boolean enlistment;
    private Boolean connectable;
    private Boolean tracking;
    private String mcp;
    private Boolean enlistmentTrace;

    public ConnectionDefinitionImpl(Map<String, String> configProperties, String className, String jndiName, String poolName, Boolean enabled, Boolean useJavaContext, Boolean useCcm, Boolean sharable, Boolean enlistment, Boolean connectable, Boolean tracking, String mcp, Boolean enlistmentTrace, Pool pool, TimeOut timeOut, Validation validation, Security security, Recovery recovery, Boolean isXA) {
        if (configProperties != null) {
            this.configProperties = new HashMap<String, String>(configProperties.size());
            this.configProperties.putAll(configProperties);
        } else {
            this.configProperties = new HashMap<String, String>(0);
        }
        this.className = className;
        this.jndiName = jndiName;
        this.poolName = poolName;
        this.enabled = enabled;
        this.useJavaContext = useJavaContext;
        this.useCcm = useCcm;
        this.pool = pool;
        this.timeOut = timeOut;
        this.validation = validation;
        this.security = security;
        this.recovery = recovery;
        this.isXA = isXA;
        this.sharable = sharable;
        this.enlistment = enlistment;
        this.connectable = connectable;
        this.tracking = tracking;
        this.mcp = mcp;
        this.enlistmentTrace = enlistmentTrace;
    }

    @Override
    public Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    @Override
    public Boolean isUseCcm() {
        return this.useCcm;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public TimeOut getTimeOut() {
        return this.timeOut;
    }

    @Override
    public Validation getValidation() {
        return this.validation;
    }

    @Override
    public Security getSecurity() {
        return this.security;
    }

    @Override
    public Recovery getRecovery() {
        return this.recovery;
    }

    @Override
    public Boolean isXa() {
        return this.pool instanceof XaPool || this.isXA != null ? this.isXA : Boolean.FALSE;
    }

    @Override
    public Boolean isSharable() {
        return this.sharable;
    }

    @Override
    public Boolean isEnlistment() {
        return this.enlistment;
    }

    @Override
    public Boolean isConnectable() {
        return this.connectable;
    }

    @Override
    public Boolean isTracking() {
        return this.tracking;
    }

    @Override
    public String getMcp() {
        return this.mcp;
    }

    @Override
    public Boolean isEnlistmentTrace() {
        return this.enlistmentTrace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.pool == null ? 0 : this.pool.hashCode());
        result = 31 * result + (this.poolName == null ? 0 : this.poolName.hashCode());
        result = 31 * result + (this.recovery == null ? 0 : this.recovery.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.timeOut == null ? 0 : this.timeOut.hashCode());
        result = 31 * result + (this.useJavaContext == null ? 0 : this.useJavaContext.hashCode());
        result = 31 * result + (this.useCcm == null ? 0 : this.useCcm.hashCode());
        result = 31 * result + (this.validation == null ? 0 : this.validation.hashCode());
        result = 31 * result + (this.isXA == null ? 0 : this.isXA.hashCode());
        result = 31 * result + (this.sharable == null ? 0 : this.sharable.hashCode());
        result = 31 * result + (this.enlistment == null ? 0 : this.enlistment.hashCode());
        result = 31 * result + (this.connectable == null ? 0 : this.connectable.hashCode());
        result = 31 * result + (this.tracking == null ? 0 : this.tracking.hashCode());
        result = 31 * result + (this.mcp == null ? 0 : this.mcp.hashCode());
        result = 31 * result + (this.enlistmentTrace == null ? 0 : this.enlistmentTrace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionDefinitionImpl)) {
            return false;
        }
        ConnectionDefinitionImpl other = (ConnectionDefinitionImpl)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        if (this.pool == null ? other.pool != null : !this.pool.equals(other.pool)) {
            return false;
        }
        if (this.poolName == null ? other.poolName != null : !this.poolName.equals(other.poolName)) {
            return false;
        }
        if (this.recovery == null ? other.recovery != null : !this.recovery.equals(other.recovery)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.timeOut == null ? other.timeOut != null : !this.timeOut.equals(other.timeOut)) {
            return false;
        }
        if (this.useJavaContext == null ? other.useJavaContext != null : !this.useJavaContext.equals(other.useJavaContext)) {
            return false;
        }
        if (this.useCcm == null ? other.useCcm != null : !this.useCcm.equals(other.useCcm)) {
            return false;
        }
        if (this.validation == null ? other.validation != null : !this.validation.equals(other.validation)) {
            return false;
        }
        if (this.isXA == null ? other.isXA != null : !this.isXA.equals(other.isXA)) {
            return false;
        }
        if (this.sharable == null ? other.sharable != null : !this.sharable.equals(other.sharable)) {
            return false;
        }
        if (this.enlistment == null ? other.enlistment != null : !this.enlistment.equals(other.enlistment)) {
            return false;
        }
        if (this.connectable == null ? other.connectable != null : !this.connectable.equals(other.connectable)) {
            return false;
        }
        if (this.tracking == null ? other.tracking != null : !this.tracking.equals(other.tracking)) {
            return false;
        }
        if (this.mcp == null ? other.mcp != null : !this.mcp.equals(other.mcp)) {
            return false;
        }
        return !(this.enlistmentTrace == null ? other.enlistmentTrace != null : !this.enlistmentTrace.equals(other.enlistmentTrace));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<connection-definition");
        if (this.className != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.CLASS_NAME).append("=\"").append(this.className).append("\"");
        }
        if (this.jndiName != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        if (this.useCcm != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.USE_CCM).append("=\"").append(this.useCcm).append("\"");
        }
        if (this.sharable != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.SHARABLE).append("=\"").append(this.sharable).append("\"");
        }
        if (this.enlistment != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.ENLISTMENT).append("=\"").append(this.enlistment).append("\"");
        }
        if (this.connectable != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.CONNECTABLE).append("=\"").append(this.connectable).append("\"");
        }
        if (this.tracking != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.TRACKING).append("=\"").append(this.tracking).append("\"");
        }
        if (this.mcp != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.MCP).append("=\"").append(this.mcp).append("\"");
        }
        if (this.enlistmentTrace != null) {
            sb.append(" ").append((Object)ConnectionDefinition.Attribute.ENLISTMENT_TRACE).append("=\"").append(this.enlistmentTrace).append("\"");
        }
        sb.append(">");
        if (this.configProperties != null && this.configProperties.size() > 0) {
            for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
                sb.append("<").append((Object)ConnectionDefinition.Tag.CONFIG_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append((Object)ConnectionDefinition.Tag.CONFIG_PROPERTY).append(">");
            }
        }
        if (this.pool != null) {
            sb.append(this.pool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.timeOut != null) {
            sb.append(this.timeOut);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.recovery != null) {
            sb.append(this.recovery);
        }
        sb.append("</connection-definition>");
        return sb.toString();
    }
}

