/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.resourceadapter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;

public class AdminObjectImpl
implements AdminObject {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> configProperties;
    private String className;
    private String jndiName;
    private String poolName;
    private Boolean enabled;
    private Boolean useJavaContext;

    public AdminObjectImpl(Map<String, String> configProperties, String className, String jndiName, String poolName, Boolean enabled, Boolean useJavaContext) {
        if (configProperties != null) {
            this.configProperties = new HashMap(configProperties.size());
            this.configProperties.putAll(configProperties);
        } else {
            this.configProperties = new HashMap(0);
        }
        this.className = className;
        this.jndiName = jndiName;
        this.poolName = poolName;
        this.enabled = enabled;
        this.useJavaContext = useJavaContext;
    }

    @Override
    public Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.poolName == null ? 0 : this.poolName.hashCode());
        result = 31 * result + (this.useJavaContext == null ? 0 : this.useJavaContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminObjectImpl)) {
            return false;
        }
        AdminObjectImpl other = (AdminObjectImpl)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        if (this.poolName == null ? other.poolName != null : !this.poolName.equals(other.poolName)) {
            return false;
        }
        return !(this.useJavaContext == null ? other.useJavaContext != null : !this.useJavaContext.equals(other.useJavaContext));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<admin-object");
        if (this.className != null) {
            sb.append(" ").append((Object)AdminObject.Attribute.CLASS_NAME).append("=\"").append(this.className).append("\"");
        }
        if (this.jndiName != null) {
            sb.append(" ").append((Object)AdminObject.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append((Object)AdminObject.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append((Object)AdminObject.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append((Object)AdminObject.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        sb.append(">");
        if (this.configProperties != null && this.configProperties.size() > 0) {
            for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
                sb.append("<").append((Object)AdminObject.Tag.CONFIG_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append((Object)AdminObject.Tag.CONFIG_PROPERTY).append(">");
            }
        }
        sb.append("</admin-object>");
        return sb.toString();
    }
}

