/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.jboss.jdeparser.ArrayJType;
import org.jboss.jdeparser.CachingLinkedHashMap;
import org.jboss.jdeparser.JAnonymousClassDef;
import org.jboss.jdeparser.JArrayExpr;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.MethodRefJExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.StaticJCall;
import org.jboss.jdeparser.StaticRefJExpr;
import org.jboss.jdeparser.WildcardJType;

abstract class AbstractJType
implements JType {
    private ArrayJType array;
    private WildcardJType wildcardExtends;
    private WildcardJType wildcardSuper;
    private CachingLinkedHashMap<String, JAssignableExpr> staticRefs;

    AbstractJType() {
    }

    static AbstractJType of(JType type) {
        if (type instanceof AbstractJType) {
            return (AbstractJType)type;
        }
        throw new IllegalArgumentException("Using a JType from a different implementation");
    }

    String qualifiedName() {
        return this.simpleName();
    }

    public abstract int hashCode();

    public final boolean equals(Object other) {
        return other instanceof AbstractJType && this.equals((AbstractJType)other);
    }

    abstract boolean equals(AbstractJType var1);

    @Override
    public abstract String simpleName();

    public abstract String toString();

    @Override
    public JExpr _class() {
        throw new UnsupportedOperationException("Adding .class to " + this);
    }

    @Override
    public JExpr _this() {
        throw new UnsupportedOperationException("Adding .this to " + this);
    }

    @Override
    public JExpr _super() {
        throw new UnsupportedOperationException("Adding .super to " + this);
    }

    @Override
    public JType array() {
        if (this.array == null) {
            this.array = new ArrayJType(this);
        }
        return this.array;
    }

    @Override
    public JCall _new() {
        throw new UnsupportedOperationException("Instantiating a " + this + " as a class");
    }

    @Override
    public JExpr _new(JExpr dim) {
        throw new UnsupportedOperationException("Instantiating a " + this + " as an array");
    }

    @Override
    public JExpr _new(int dim) {
        return this._new(JExprs.decimal(dim));
    }

    @Override
    public JArrayExpr _newArray() {
        throw new UnsupportedOperationException("Instantiating a " + this + " as an array");
    }

    @Override
    public JAnonymousClassDef _newAnon() {
        throw new UnsupportedOperationException("Instantiating a " + this + " as a class");
    }

    @Override
    public JType typeArg(String ... args) {
        JType[] types = new JType[args.length];
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            types[i] = JTypes.typeNamed(args[i]);
        }
        return this.typeArg(types);
    }

    @Override
    public JType typeArg(JType ... args) {
        throw new UnsupportedOperationException("Adding type arguments to " + this);
    }

    @Override
    public JType typeArg(Class<?> ... args) {
        JType[] types = new JType[args.length];
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            types[i] = JTypes.typeOf(args[i]);
        }
        return this.typeArg(types);
    }

    @Override
    public JType[] typeArgs() {
        return NONE;
    }

    @Override
    public JType erasure() {
        return this;
    }

    @Override
    public JType elementType() {
        throw new UnsupportedOperationException("Getting element type from " + this);
    }

    @Override
    public JType box() {
        return this;
    }

    @Override
    public JType unbox() {
        return this;
    }

    @Override
    public JType wildcardExtends() {
        if (this.wildcardExtends == null) {
            this.wildcardExtends = new WildcardJType(this, true);
        }
        return this.wildcardExtends;
    }

    @Override
    public JType wildcardSuper() {
        if (this.wildcardSuper == null) {
            this.wildcardSuper = new WildcardJType(this, false);
        }
        return this.wildcardSuper;
    }

    @Override
    public JType nestedType(String name) {
        throw new UnsupportedOperationException("Lookup of nested type on " + this);
    }

    @Override
    public JType $t(String name) {
        return this.nestedType(name);
    }

    @Override
    public JAssignableExpr field(String name) {
        JAssignableExpr expr;
        CachingLinkedHashMap<String, JAssignableExpr> map = this.staticRefs;
        if (map == null) {
            this.staticRefs = new CachingLinkedHashMap();
            map = this.staticRefs;
        }
        if ((expr = (JAssignableExpr)map.get(name)) == null) {
            expr = new StaticRefJExpr(this, name);
            map.put(name, expr);
        }
        return expr;
    }

    @Override
    public JAssignableExpr $v(String name) {
        return this.field(name);
    }

    @Override
    public JCall call(String name) {
        return new StaticJCall(this, name);
    }

    @Override
    public JCall call(ExecutableElement method) {
        ElementKind kind = method.getKind();
        if (kind == ElementKind.METHOD && !method.getModifiers().contains((Object)Modifier.STATIC)) {
            String name = method.getSimpleName().toString();
            return this.call(name);
        }
        throw new IllegalArgumentException("Unsupported element for call: " + method);
    }

    @Override
    public JExpr methodRef(String name) {
        return new MethodRefJExpr(this, name);
    }

    @Override
    public JExpr methodRef(ExecutableElement method) {
        ElementKind kind = method.getKind();
        if (kind == ElementKind.METHOD && !method.getModifiers().contains((Object)Modifier.STATIC)) {
            String name = method.getSimpleName().toString();
            return this.methodRef(name);
        }
        throw new IllegalArgumentException("Unsupported element for method ref: " + method);
    }

    abstract void writeDirect(SourceFileWriter var1) throws IOException;
}

