/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.dtd;

import com.sun.xml.dtdparser.DTDEventListener;
import com.sun.xml.dtdparser.InputEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.shrinkwrap.descriptor.metadata.BaseMetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MetadataDtdEventListener
implements DTDEventListener {
    private final Metadata metadata;
    private final boolean isVerbose;
    private String currentContentModel = "";
    private List<Map<String, Short>> modelGroupStack;

    public MetadataDtdEventListener(Metadata metadata, boolean isVerbose) {
        this.metadata = metadata;
        this.isVerbose = isVerbose;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setDocumentLocator(Locator loc) {
        if (this.isVerbose) {
            System.out.println("setDocumentLocator:" + loc);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.isVerbose) {
            System.out.println("processingInstruction: Target" + target + "  Data:" + data);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.isVerbose) {
            System.out.println("notationDecl: name" + name + "  publicId:" + publicId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.isVerbose) {
            System.out.println("unparsedEntityDecl: name" + name + "  publicId:" + publicId);
        }
    }

    public void internalGeneralEntityDecl(String name, String value) throws SAXException {
        if (this.isVerbose) {
            System.out.println("internalGeneralEntityDecl: name" + name + "  value:" + value);
        }
    }

    public void externalGeneralEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.isVerbose) {
            System.out.println("externalGeneralEntityDecl: name" + name + "  publicId:" + publicId);
        }
    }

    public void internalParameterEntityDecl(String name, String value) throws SAXException {
        if (this.isVerbose) {
            System.out.println("internalParameterEntityDecl: name" + name + "  value:" + value);
        }
    }

    public void externalParameterEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.isVerbose) {
            System.out.println("externalParameterEntityDecl: name" + name + "  publicId:" + publicId);
        }
    }

    public void startDTD(InputEntity in) throws SAXException {
        if (this.isVerbose) {
            System.out.println("startDTD: InputEntity" + in);
        }
    }

    public void endDTD() throws SAXException {
        if (this.isVerbose) {
            System.out.println("endDTD: InputEntity");
        }
    }

    public void comment(String text) throws SAXException {
        if (this.isVerbose) {
            System.out.println("comment:" + text);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isVerbose) {
            System.out.println("characters:");
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.isVerbose) {
            System.out.println("ignorableWhitespace:");
        }
    }

    public void startCDATA() throws SAXException {
        if (this.isVerbose) {
            System.out.println("startCDATA:");
        }
    }

    public void endCDATA() throws SAXException {
        if (this.isVerbose) {
            System.out.println("endCDATA:");
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warning(SAXParseException err) throws SAXException {
        if (this.isVerbose) {
            err.printStackTrace();
        } else {
            System.out.println("warning:" + err.getMessage());
        }
    }

    public void startContentModel(String elementName, short contentModelType) throws SAXException {
        if (this.isVerbose) {
            System.out.println("startContentModel: elementName: " + elementName + " contentModelType: " + contentModelType);
        }
        this.currentContentModel = elementName;
        this.modelGroupStack = new ArrayList<Map<String, Short>>();
        if (contentModelType == 2) {
            MetadataElement element = new MetadataElement();
            element.setName(elementName);
            element.setType("text");
            this.metadata.addClassElement(elementName, element);
        }
    }

    public void endContentModel(String elementName, short contentModelType) throws SAXException {
        if (this.isVerbose) {
            System.out.println("endContentModel: elementName: " + elementName + " contentModelType: " + contentModelType);
        }
        int childElementCounter = 0;
        BaseMetadataItem foundClass = null;
        for (MetadataItem metadataClass : this.metadata.getClassList()) {
            if (!metadataClass.getName().equals(this.currentContentModel)) continue;
            childElementCounter = metadataClass.getElements().size();
            foundClass = metadataClass;
            break;
        }
        boolean isJustPCDATA = false;
        if (childElementCounter == 0) {
            isJustPCDATA = true;
        } else if (childElementCounter == 1 && foundClass.getName().equals(this.currentContentModel) && contentModelType == 2) {
            isJustPCDATA = true;
        }
        if (isJustPCDATA) {
            MetadataItem type = new MetadataItem(this.currentContentModel);
            type.setMappedTo("xsd:string");
            type.setNamespace(this.metadata.getCurrentNamespace());
            this.metadata.getDataTypeList().add(type);
            if (foundClass != null) {
                this.metadata.getClassList().remove(foundClass);
            }
        }
        this.currentContentModel = "";
        this.modelGroupStack = null;
    }

    public void attributeDecl(String elementName, String attributeName, String attributeType, String[] enumeration, short attributeUse, String defaultValue) throws SAXException {
        if (this.isVerbose) {
            System.out.println("attributeDecl: elementName: " + elementName + " attributeName: " + attributeName + " attributeType: " + attributeType + " enumeration: " + enumeration + " attributeUse: " + attributeUse);
        }
        if (!attributeType.equals("ID")) {
            MetadataElement element = new MetadataElement();
            element.setName(attributeName);
            element.setIsAttribute(true);
            element.setType("xsd:string");
            this.metadata.addClassElement(elementName, element);
        }
    }

    public void childElement(String elementName, short occurence) throws SAXException {
        if (this.isVerbose) {
            System.out.println("childElement: elementName: " + elementName + " occurence: " + occurence);
        }
        Map<String, Short> modelGroupElements = this.modelGroupStack.get(this.modelGroupStack.size() - 1);
        modelGroupElements.put(elementName, occurence);
    }

    public void mixedElement(String elementName) throws SAXException {
        if (this.isVerbose) {
            System.out.println("mixedElement: elementName: " + elementName);
        }
        MetadataElement element = new MetadataElement();
        element.setName(elementName);
        element.setType(elementName);
        this.metadata.addClassElement(this.currentContentModel, element);
    }

    public void startModelGroup() throws SAXException {
        if (this.isVerbose) {
            System.out.println("startModelGroup:");
        }
        this.modelGroupStack.add(new HashMap());
    }

    public void endModelGroup(short occurence) throws SAXException {
        if (this.isVerbose) {
            System.out.println("endModelGroup: occurence: " + occurence);
        }
        Map<String, Short> modelGroupElements = this.modelGroupStack.get(this.modelGroupStack.size() - 1);
        for (Map.Entry<String, Short> entry : modelGroupElements.entrySet()) {
            String elementName = entry.getKey();
            Short elementOccurence = entry.getValue();
            boolean isUnbounded = false;
            if (occurence == 0 || occurence == 1 || elementOccurence == 0 || elementOccurence == 1) {
                isUnbounded = true;
            }
            MetadataElement element = new MetadataElement();
            element.setName(elementName);
            element.setType(elementName);
            if (isUnbounded) {
                element.setMaxOccurs("unbounded");
            }
            this.metadata.addClassElement(this.currentContentModel, element);
        }
        this.modelGroupStack.remove(modelGroupElements);
    }

    public void connector(short connectorType) throws SAXException {
        if (this.isVerbose) {
            System.out.println("connector: connectorType: " + connectorType);
        }
    }
}

