/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAssert
extends ObjectGroupAssert<CollectionAssert, Collection<?>> {
    protected CollectionAssert(Collection<?> actual) {
        super(CollectionAssert.class, actual);
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Collection)this.actual).size();
    }

    @Override
    public CollectionAssert onProperty(String propertyName) {
        this.isNotNull();
        if (((Collection)this.actual).isEmpty()) {
            return new CollectionAssert(Collections.emptyList());
        }
        return new CollectionAssert(PropertySupport.instance().propertyValues(propertyName, (Collection)this.actual));
    }

    @Override
    protected Set<Object> actualAsSet() {
        return new LinkedHashSet<Object>((Collection)this.actual);
    }

    @Override
    protected List<Object> actualAsList() {
        return new ArrayList<Object>((Collection)this.actual);
    }
}

