/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.SecurityPermission;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.spec.XML;

public class SecurityPermissionImpl
implements SecurityPermission {
    private static final long serialVersionUID = 1L;
    private ArrayList<LocalizedXsdString> description;
    private XsdString securityPermissionSpec;
    private String id;

    public SecurityPermissionImpl(List<LocalizedXsdString> description, XsdString securityPermissionSpec, String id) {
        if (description != null) {
            this.description = new ArrayList<LocalizedXsdString>(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag(XML.SecurityPermissionTag.DESCRIPTION.toString());
            }
        } else {
            this.description = new ArrayList(0);
        }
        this.securityPermissionSpec = securityPermissionSpec;
        if (!XsdString.isNull(this.securityPermissionSpec)) {
            this.securityPermissionSpec.setTag(XML.SecurityPermissionTag.SECURITY_PERMISSION_SPEC.toString());
        }
        this.id = id;
    }

    @Override
    public List<LocalizedXsdString> getDescriptions() {
        return Collections.unmodifiableList(this.description);
    }

    @Override
    public XsdString getSecurityPermissionSpec() {
        return this.securityPermissionSpec;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public CopyableMetaData copy() {
        return new SecurityPermissionImpl(CopyUtil.cloneList(this.description), CopyUtil.clone(this.securityPermissionSpec), CopyUtil.cloneString(this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.securityPermissionSpec == null ? 0 : this.securityPermissionSpec.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityPermissionImpl)) {
            return false;
        }
        SecurityPermissionImpl other = (SecurityPermissionImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.securityPermissionSpec == null ? other.securityPermissionSpec != null : !this.securityPermissionSpec.equals(other.securityPermissionSpec));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<security-permission");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.description != null) {
            for (LocalizedXsdString s : this.description) {
                sb.append(s);
            }
        }
        sb.append(this.securityPermissionSpec);
        sb.append("</security-permission>");
        return sb.toString();
    }
}

