/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jboss.jdeparser.AbstractJDocComment;
import org.jboss.jdeparser.CommentIndentation;
import org.jboss.jdeparser.DocTagJHtmlComment;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.Indent;
import org.jboss.jdeparser.JDocComment;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Writable;

class ImplJDocComment
extends AbstractJDocComment
implements JDocComment {
    private static final Indent escIndent = new Indent(){

        @Override
        public void addIndent(Indent next, FormatPreferences preferences, StringBuilder lineBuffer) {
            int idx = lineBuffer.length();
            next.addIndent(next, preferences, lineBuffer);
            next.escape(next, lineBuffer, idx);
        }

        @Override
        public void escape(Indent next, StringBuilder b, int idx) {
            int i = idx;
            block20: while (i < b.length()) {
                int c = b.codePointAt(i);
                int end = b.offsetByCodePoints(i, 1);
                switch (c) {
                    case 60: {
                        b.replace(i, end, "&lt;");
                        i += 4;
                        continue block20;
                    }
                    case 62: {
                        b.replace(i, end, "&gt;");
                        i += 4;
                        continue block20;
                    }
                    case 38: {
                        b.replace(i, end, "&amp;");
                        i += 5;
                        continue block20;
                    }
                    case 64: {
                        b.replace(i, end, "&#64;");
                        i += 5;
                        continue block20;
                    }
                    case 173: {
                        b.replace(i, end, "&shy;");
                        i += 5;
                        continue block20;
                    }
                    case 8205: {
                        b.replace(i, end, "&zwj;");
                        i += 5;
                        continue block20;
                    }
                    case 8206: {
                        b.replace(i, end, "&lrm;");
                        i += 5;
                        continue block20;
                    }
                    case 8207: {
                        b.replace(i, end, "&rlm;");
                        i += 5;
                        continue block20;
                    }
                    case 160: {
                        b.replace(i, end, "&nbsp;");
                        i += 6;
                        continue block20;
                    }
                    case 8194: {
                        b.replace(i, end, "&ensp;");
                        i += 6;
                        continue block20;
                    }
                    case 8195: {
                        b.replace(i, end, "&emsp;");
                        i += 6;
                        continue block20;
                    }
                    case 8204: {
                        b.replace(i, end, "&zwnj;");
                        i += 6;
                        continue block20;
                    }
                    case 8201: {
                        b.replace(i, end, "&thisp;");
                        i += 7;
                        continue block20;
                    }
                    case 32: {
                        ++i;
                        continue block20;
                    }
                    case 10: {
                        ++i;
                        continue block20;
                    }
                }
                switch (Character.getType(c)) {
                    case 0: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 19: {
                        b.replace(i, end, "&#x");
                        String hs = Integer.toHexString(c);
                        b.insert(i += 3, hs);
                        b.insert(i += hs.length(), ';');
                        continue block20;
                    }
                }
                ++i;
            }
            next.escape(next, b, idx);
        }

        @Override
        public void unescaped(Indent next, StringBuilder b, int idx) {
            next.escape(next, b, idx);
        }
    };

    ImplJDocComment() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.addIndent();
        writer.writeEscaped("/**");
        writer.pushIndent(CommentIndentation.BLOCK);
        try {
            writer.pushIndent(escIndent);
            try {
                Map<String, List<DocTagJHtmlComment>> docTags;
                List<Writable> contents = this.getContent();
                if (contents != null && !contents.isEmpty()) {
                    writer.nl();
                    for (Writable content : contents) {
                        content.write(writer);
                    }
                }
                if ((docTags = this.getDocTags()) != null) {
                    for (Map.Entry<String, List<DocTagJHtmlComment>> entry : docTags.entrySet()) {
                        List<DocTagJHtmlComment> values = entry.getValue();
                        if (values == null) continue;
                        for (DocTagJHtmlComment value : values) {
                            value.write(writer);
                        }
                    }
                }
            }
            finally {
                writer.popIndent(escIndent);
            }
        }
        finally {
            writer.popIndent(CommentIndentation.BLOCK);
        }
        writer.nl();
        writer.addIndent();
        writer.writeEscaped(" */");
        writer.nl();
    }
}

