/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.fest.util.ArrayFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private static final ArrayFormatter formatter = new ArrayFormatter();

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || !Arrays.hasElements(array);
    }

    public static <T> T[] array(T ... values) {
        return values;
    }

    public static String format(Object array) {
        return formatter.format(array);
    }

    public static <T> T[] nonNullElements(T[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<T> nonNullElements = new ArrayList<T>();
        for (T o : array) {
            if (o == null) continue;
            nonNullElements.add(o);
        }
        int elementCount = nonNullElements.size();
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), elementCount);
        System.arraycopy(nonNullElements.toArray(), 0, newArray, 0, elementCount);
        return newArray;
    }

    public static <T> boolean hasOnlyNullElements(T[] array) {
        if (array == null) {
            throw new NullPointerException("The array to check should not be null");
        }
        if (!Arrays.hasElements(array)) {
            return false;
        }
        for (T o : array) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean hasElements(T[] array) {
        return array.length > 0;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        Object[] copy = (Object[])Array.newInstance(original.getClass().getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private Arrays() {
    }
}

