/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.xslt;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltTransformer {
    public static void simpleTransform(String sourcePath, String xsltPath, String resultDir, Map<String, String> parameters) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        Transformer transformer = tFactory.newTransformer(new StreamSource(new File(xsltPath)));
        XsltTransformer.applyParameters(transformer, parameters);
        transformer.transform(new StreamSource(new File(sourcePath)), new StreamResult(new File(resultDir)));
    }

    public static void simpleTransform(String sourcePath, StreamSource xsltSource, String resultDir, Map<String, String> parameters) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        Transformer transformer = tFactory.newTransformer(xsltSource);
        XsltTransformer.applyParameters(transformer, parameters);
        transformer.transform(new StreamSource(new File(sourcePath)), new StreamResult(new File(resultDir + "/metadata.xml")));
    }

    public static void simpleTransform(String contextFile, InputStream xsltSource, File result, Map<String, String> parameters) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        Transformer transformer = tFactory.newTransformer(new StreamSource(xsltSource));
        XsltTransformer.applyParameters(transformer, parameters);
        transformer.transform(new StreamSource(new File(contextFile)), new StreamResult(result));
    }

    private static void applyParameters(Transformer transformer, Map<String, String> parameters) {
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            transformer.setParameter(key, parameters.get(key));
        }
    }
}

