/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.filter;

import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataUtil;
import org.jboss.shrinkwrap.descriptor.metadata.filter.Filter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdElementEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class GroupFilter
implements Filter {
    public boolean filter(Metadata metadata, TreeWalker walker) {
        Node refNode;
        Node parent = walker.getCurrentNode();
        Element element = (Element)parent;
        if (XsdElementEnum.group.isTagNameEqual(element.getTagName()) && (refNode = element.getAttributes().getNamedItem("ref")) != null) {
            Node parentNodeWithName;
            MetadataElement refElement = new MetadataElement(element);
            refElement.setIsRef(true);
            Node parentNodeWithMaxOccurs = MetadataUtil.getNextParentNodeWithAttr(parent, "maxOccurs");
            Element p = (Element)parentNodeWithMaxOccurs;
            String maxOccurs = MetadataUtil.getAttributeValue(p, "maxOccurs");
            if (maxOccurs != null && !maxOccurs.equals("1")) {
                refElement.setMaxOccurs("unbounded");
            }
            if ((parentNodeWithName = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "name")) != null) {
                Element parentElementWithName = (Element)parentNodeWithName;
                String groupOrClassName = MetadataUtil.getAttributeValue(parentElementWithName, "name");
                if (XsdElementEnum.group.isTagNameEqual(parentElementWithName.getTagName())) {
                    metadata.addGroupReference(groupOrClassName, refElement);
                    return true;
                }
                metadata.addClassReference(groupOrClassName, refElement);
                return true;
            }
        }
        return false;
    }
}

