/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.filter;

import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataUtil;
import org.jboss.shrinkwrap.descriptor.metadata.filter.Filter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdElementEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class ExtensionFilter
implements Filter {
    public boolean filter(Metadata metadata, TreeWalker walker) {
        String baseStr;
        Node parent = walker.getCurrentNode();
        Element element = (Element)parent;
        if (XsdElementEnum.extension.isTagNameEqual(element.getTagName()) && (baseStr = MetadataUtil.getAttributeValue(element, "base")) != null) {
            for (MetadataItem metadataClass : metadata.getClassList()) {
                Element parentElementWithName;
                String className;
                if (!metadataClass.getName().equals(baseStr)) continue;
                Node parentNodeWithName = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "name");
                if (parentNodeWithName != null && (className = MetadataUtil.getAttributeValue(parentElementWithName = (Element)parentNodeWithName, "name")) != null) {
                    for (MetadataElement metadataElement : metadataClass.getElements()) {
                        metadata.addClassElement(className, metadataElement);
                    }
                }
                return true;
            }
            Node parentNodeWithName = MetadataUtil.getNextParentNodeWithAttr(parent.getParentNode(), "name");
            if (parentNodeWithName != null) {
                Element parentElementWithName = (Element)parentNodeWithName;
                String mixedStr = MetadataUtil.getAttributeValue(parentElementWithName, "mixed");
                boolean isTextOnlyElement = MetadataUtil.hasParentOf(element, XsdElementEnum.simpleContent);
                if (!(isTextOnlyElement && !parentElementWithName.hasChildNodes() && baseStr.indexOf(":string") <= 0 || mixedStr != null && !mixedStr.equals("false"))) {
                    String dataTypeName = MetadataUtil.getAttributeValue(parentElementWithName, "name");
                    String typeStr = MetadataUtil.getAttributeValue(element, "base");
                    MetadataItem dataType = new MetadataItem(dataTypeName);
                    dataType.setMappedTo(typeStr);
                    dataType.setNamespace(metadata.getCurrentNamespace());
                    dataType.setSchemaName(metadata.getCurrentSchmema());
                    metadata.getDataTypeList().add(dataType);
                }
            }
        }
        return false;
    }
}

