/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.HashSet;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JMethod;
import org.jboss.logging.processor.generator.model.ImplementationClassModel;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class MessageBundleImplementor
extends ImplementationClassModel {
    public MessageBundleImplementor(MessageInterface messageInterface) {
        super(messageInterface);
    }

    @Override
    protected JDeparser generateModel() throws IllegalStateException {
        JDeparser codeModel = super.generateModel();
        this.getDefinedClass().constructor(2);
        this.createReadResolveMethod();
        HashSet<MessageMethod> messageMethods = new HashSet<MessageMethod>();
        messageMethods.addAll(this.messageInterface().methods());
        for (MessageInterface messageInterface : this.messageInterface().extendedInterfaces()) {
            if (messageInterface.isLoggerInterface()) continue;
            messageMethods.addAll(messageInterface.methods());
        }
        for (MessageMethod messageMethod : messageMethods) {
            JClass returnType = codeModel.directClass(messageMethod.returnType().name());
            JMethod jMethod = this.getDefinedClass().method(9, returnType, messageMethod.name());
            JMethod msgMethod = this.addMessageMethod(messageMethod);
            this.createBundleMethod(messageMethod, jMethod, msgMethod);
        }
        return codeModel;
    }
}

