/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupAssert<S, A>
extends GenericAssert<S, A> {
    protected GroupAssert(Class<S> selfType, A actual) {
        super(selfType, actual);
    }

    public final void isNullOrEmpty() {
        if (this.actual == null || !this.hasElements()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("expecting null or empty, but was:<%s>", this.actual));
    }

    public final void isEmpty() {
        this.isNotNull();
        if (!this.hasElements()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("expecting empty, but was:<%s>", this.actual));
    }

    private boolean hasElements() {
        return this.actualGroupSize() > 0;
    }

    public final S isNotEmpty() {
        this.isNotNull();
        if (this.hasElements()) {
            return (S)this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure("expecting non-empty, but it was empty");
    }

    public final S hasSize(int expected) {
        this.isNotNull();
        int size = this.actualGroupSize();
        if (size == expected) {
            return (S)this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("expected size:<%s> but was:<%s> for <%s>", expected, size, this.actual));
    }

    protected abstract int actualGroupSize();
}

