/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.util.Strings;
import org.fest.util.ToString;

public final class Formatting {
    private static final String EMPTY_MESSAGE = "";

    static String createMessageFrom(Description description, Object[] message) {
        return Formatting.format(description, Strings.concat(message));
    }

    public static String format(Description description, String message) {
        String s = Formatting.valueOf(description);
        return Formatting.format(s) + message;
    }

    public static String valueOf(Description description) {
        return description == null ? null : description.value();
    }

    public static String format(String message) {
        if (Strings.isEmpty(message)) {
            return EMPTY_MESSAGE;
        }
        return String.format("[%s] ", message);
    }

    public static String inBrackets(Object o) {
        return Formatting.doBracketAround(ToString.toStringOf(o));
    }

    private static String doBracketAround(String s) {
        return String.format("<%s>", s);
    }

    public static String format(String format, Object ... args) {
        Object[] argsAsText = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            argsAsText[i] = ToString.toStringOf(args[i]);
        }
        return String.format(format, argsAsText);
    }

    private Formatting() {
    }
}

