/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.sjc.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.tools.ant.BuildException;
import org.jboss.jca.sjc.ant.AbstractHostPortTask;

public class Deploy
extends AbstractHostPortTask {
    private File file = null;

    public void setFile(File v) {
        this.file = v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws BuildException {
        if (this.file == null) {
            throw new BuildException("File not defined");
        }
        if (!this.file.exists()) {
            throw new BuildException("File doesn't exists: " + this.file);
        }
        FileInputStream fis = null;
        try {
            Boolean result = null;
            if (this.isLocal()) {
                Serializable value = this.executeCommand("local-deploy", new Serializable[]{this.file.toURI().toURL()});
                if (!(value instanceof Boolean)) throw (Throwable)value;
                result = (Boolean)value;
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                fis = new FileInputStream(this.file);
                int i = fis.read();
                while (i != -1) {
                    baos.write(i);
                    i = fis.read();
                }
                byte[] bytes = baos.toByteArray();
                Serializable value = this.executeCommand("remote-deploy", new Serializable[]{this.file.getName(), bytes});
                if (!(value instanceof Boolean)) throw (Throwable)value;
                result = (Boolean)value;
            }
            if (result.booleanValue()) {
                this.log("Deployed: " + this.file.getName());
                return;
            } else {
                this.log(this.file.getName() + " wasn't deployed");
            }
            return;
        }
        catch (Throwable t) {
            throw new BuildException("Unable to deploy to " + this.getHost() + ":" + this.getPort() + " (" + t.getMessage() + ")", t);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException result) {}
            }
        }
    }
}

