/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.test.eis.maven;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.jca.test.eis.impl.EISServer;
import org.jboss.jca.test.eis.maven.EISMojo;
import org.jboss.jca.test.eis.maven.SecurityActions;

public class Start
extends EISMojo {
    private String handler = null;
    private List<File> classpath = null;

    public void setHandler(String v) {
        this.handler = v;
    }

    public void setClasspath(List<File> v) {
        this.classpath = v;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldCl = SecurityActions.getThreadContextClassLoader();
        try {
            URLClassLoader cl = null;
            if (this.classpath != null) {
                ArrayList<URL> urls = new ArrayList<URL>(this.classpath.size());
                for (File f : this.classpath) {
                    urls.add(f.toURI().toURL());
                }
                cl = SecurityActions.createURLCLassLoader(urls.toArray(new URL[urls.size()]), Start.class.getClassLoader());
                SecurityActions.setThreadContextClassLoader(cl);
            }
            EISServer eisServer = new EISServer();
            eisServer.setHost(this.getHost());
            eisServer.setPort(this.getPort());
            eisServer.setHandlerClassName(this.handler);
            eisServer.setClassLoader(cl);
            eisServer.startup();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Error during start: " + t.getMessage(), t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldCl);
        }
    }
}

