/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.DeployerPhases;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.management.ObjectName;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.MessageListener;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.AbstractFungalRADeployer;
import org.jboss.jca.deployers.fungal.RAActivatorComparator;
import org.jboss.jca.deployers.fungal.RAActivatorDeployment;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public final class RAActivator
extends AbstractFungalRADeployer
implements DeployerPhases {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)RAActivator.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private boolean enabled = true;
    private Set<String> excludeArchives = null;
    private List<Deployment> deployments = null;

    public RAActivator() {
        super(false);
    }

    protected DeployersLogger getLogger() {
        return log;
    }

    public Set<String> getExcludeArchives() {
        return this.excludeArchives;
    }

    public void setExcludeArchives(Set<String> archives) {
        this.excludeArchives = archives;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public void preDeploy() throws Throwable {
    }

    public void postDeploy() throws Throwable {
        if (this.enabled) {
            MetadataRepository mdr = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            ResourceAdapterRepository rar = ((RAConfiguration)this.getConfiguration()).getResourceAdapterRepository();
            Set rarDeployments = mdr.getResourceAdapters();
            Set<String> configuredRars = this.getConfiguredResourceAdapters(mdr, rar);
            for (String deployment : rarDeployments) {
                Deployment raDeployment;
                if (trace) {
                    log.trace((Object)("Processing: " + deployment));
                }
                boolean include = true;
                if (this.excludeArchives != null) {
                    for (String excludedArchive : this.excludeArchives) {
                        if (!deployment.endsWith(excludedArchive)) continue;
                        include = false;
                    }
                }
                if (!include || configuredRars.contains(deployment) || (raDeployment = this.deploy(new URL(deployment), (ClassLoader)this.kernel.getKernelClassLoader())) == null) continue;
                if (this.deployments == null) {
                    this.deployments = new ArrayList<Deployment>(1);
                }
                this.deployments.add(raDeployment);
                this.kernel.getMainDeployer().registerDeployment(raDeployment);
            }
        }
    }

    public void preUndeploy() throws Throwable {
        if (this.deployments != null) {
            for (Deployment raDeployment : this.deployments) {
                try {
                    this.kernel.getMainDeployer().unregisterDeployment(raDeployment);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error during undeployment of " + raDeployment.getURL()));
                }
            }
            this.deployments = null;
        }
    }

    public void postUndeploy() throws Throwable {
    }

    private Set<String> getConfiguredResourceAdapters(MetadataRepository mdr, ResourceAdapterRepository rar) {
        HashSet<String> configured = new HashSet<String>();
        TreeSet<String> deployments = new TreeSet<String>(new RAActivatorComparator());
        for (String entry : mdr.getResourceAdapters()) {
            deployments.add(entry);
        }
        for (String deployment : deployments) {
            if (deployment.endsWith(".rar")) {
                try {
                    if (!mdr.hasJndiMappings(deployment) && !this.hasResourceAdapter(rar, mdr.getResourceAdapter(deployment))) continue;
                    configured.add(deployment);
                }
                catch (Throwable t) {}
                continue;
            }
            if (!deployment.endsWith("-ra.xml")) continue;
            configured.add(deployment);
            try {
                Connector raXml = mdr.getResourceAdapter(deployment);
                for (String entry : mdr.getResourceAdapters()) {
                    Connector entryXml;
                    if (!entry.endsWith(".rar") || !this.sameStructure(raXml, entryXml = mdr.getResourceAdapter(entry))) continue;
                    configured.add(entry);
                }
            }
            catch (Throwable t) {
                log.debugf(t, "Ignoring: %s", (Object)deployment);
            }
        }
        return configured;
    }

    private boolean sameStructure(Connector c1, Connector c2) {
        if (c1 == null || c1.getResourceadapter() == null) {
            return false;
        }
        if (c2 == null || c2.getResourceadapter() == null) {
            return false;
        }
        org.jboss.jca.common.api.metadata.spec.ResourceAdapter ra1 = c1.getResourceadapter();
        org.jboss.jca.common.api.metadata.spec.ResourceAdapter ra2 = c2.getResourceadapter();
        HashSet<String> clzRa1 = new HashSet<String>();
        HashSet<String> clzMcf1 = new HashSet<String>();
        HashSet<String> clzAo1 = new HashSet<String>();
        HashSet<String> clzAS1 = new HashSet<String>();
        if (ra1.getResourceadapterClass() != null) {
            clzRa1.add(ra1.getResourceadapterClass());
        }
        if (ra1.getOutboundResourceadapter() != null && ra1.getOutboundResourceadapter().getConnectionDefinitions() != null) {
            for (ConnectionDefinition cd : ra1.getOutboundResourceadapter().getConnectionDefinitions()) {
                clzMcf1.add(cd.getManagedConnectionFactoryClass().getValue());
            }
        }
        if (ra1.getAdminObjects() != null) {
            for (AdminObject ao : ra1.getAdminObjects()) {
                clzAo1.add(ao.getAdminobjectClass().getValue());
            }
        }
        if (ra1.getInboundResourceadapter() != null && ra1.getInboundResourceadapter().getMessageadapter() != null && ra1.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null) {
            for (MessageListener ml : ra1.getInboundResourceadapter().getMessageadapter().getMessagelisteners()) {
                clzAS1.add(ml.getActivationspec().getActivationspecClass().getValue());
            }
        }
        HashSet<String> clzRa2 = new HashSet<String>();
        HashSet<String> clzMcf2 = new HashSet<String>();
        HashSet<String> clzAo2 = new HashSet<String>();
        HashSet<String> clzAS2 = new HashSet<String>();
        if (ra2.getResourceadapterClass() != null) {
            clzRa2.add(ra2.getResourceadapterClass());
        }
        if (ra2.getOutboundResourceadapter() != null && ra2.getOutboundResourceadapter().getConnectionDefinitions() != null) {
            for (ConnectionDefinition cd : ra2.getOutboundResourceadapter().getConnectionDefinitions()) {
                clzMcf2.add(cd.getManagedConnectionFactoryClass().getValue());
            }
        }
        if (ra2.getAdminObjects() != null) {
            for (AdminObject ao : ra2.getAdminObjects()) {
                clzAo2.add(ao.getAdminobjectClass().getValue());
            }
        }
        if (ra2.getInboundResourceadapter() != null && ra2.getInboundResourceadapter().getMessageadapter() != null && ra2.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null) {
            for (MessageListener ml : ra2.getInboundResourceadapter().getMessageadapter().getMessagelisteners()) {
                clzAS2.add(ml.getActivationspec().getActivationspecClass().getValue());
            }
        }
        if (clzRa1.size() != clzRa2.size()) {
            return false;
        }
        if (clzMcf1.size() != clzMcf2.size()) {
            return false;
        }
        if (clzAo1.size() != clzAo2.size()) {
            return false;
        }
        if (clzAS1.size() != clzAS2.size()) {
            return false;
        }
        for (String s : clzRa1) {
            if (clzRa2.contains(s)) continue;
            return false;
        }
        for (String s : clzMcf1) {
            if (clzMcf2.contains(s)) continue;
            return false;
        }
        for (String s : clzAo1) {
            if (clzAo2.contains(s)) continue;
            return false;
        }
        for (String s : clzAS1) {
            if (clzAS2.contains(s)) continue;
            return false;
        }
        return true;
    }

    private boolean hasResourceAdapter(ResourceAdapterRepository rar, Connector c) {
        org.jboss.jca.common.api.metadata.spec.ResourceAdapter ra;
        if (rar != null && c != null && c.getResourceadapter() != null && (ra = c.getResourceadapter()).getResourceadapterClass() != null) {
            String clz = ra.getResourceadapterClass();
            for (String deployment : rar.getResourceAdapters()) {
                try {
                    ResourceAdapter instance = rar.getResourceAdapter(deployment);
                    if (!clz.equals(instance.getClass().getName())) continue;
                    return true;
                }
                catch (Throwable t) {
                }
            }
        }
        return false;
    }

    private Deployment deploy(URL url, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploying: " + url.toExternalForm()));
        }
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                Deployment deployment = null;
                return deployment;
            }
            File root = null;
            if (f.isFile()) {
                File destination = new File(SecurityActions.getSystemProperty("iron.jacamar.home"), "/tmp/");
                File target = new File(destination, f.getName());
                if (!target.exists()) {
                    FileUtil fileUtil = new FileUtil();
                    root = fileUtil.extract(f, destination);
                } else {
                    root = target;
                }
            } else {
                root = f;
            }
            String deploymentName = f.getName().substring(0, f.getName().indexOf(".rar"));
            URL[] urls = this.getUrls(root);
            KernelClassLoader cl = null;
            cl = ((RAConfiguration)this.getConfiguration()).getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
            SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            MetadataRepository metadataRepository = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            Connector cmd = metadataRepository.getResourceAdapter(url.toExternalForm());
            Activation activation = metadataRepository.getActivation(url.toExternalForm());
            if (cmd != null) {
                cmd = (Connector)cmd.copy();
            }
            cmd = new Merger().mergeConnectorWithCommonIronJacamar(activation, cmd);
            CommonDeployment c = this.createObjectsAndInjectValue(url, deploymentName, root, (ClassLoader)cl, cmd, activation);
            List<ObjectName> ons = this.registerManagementView(c.getConnector(), this.kernel.getMBeanServer(), this.kernel.getName());
            JndiStrategy jndiStrategy = ((RAConfiguration)this.getConfiguration()).getJndiStrategy();
            ResourceAdapterRepository resourceAdapterRepository = ((RAConfiguration)this.getConfiguration()).getResourceAdapterRepository();
            RAActivatorDeployment rAActivatorDeployment = new RAActivatorDeployment(c.getURL(), c.getDeploymentName(), c.getResourceAdapter(), c.getResourceAdapterKey(), c.getBootstrapContextIdentifier(), jndiStrategy, metadataRepository, resourceAdapterRepository, c.getCfs(), c.getCfJndiNames(), c.getConnectionManagers(), c.getAos(), c.getAoJndiNames(), c.getRecovery(), this.getTransactionIntegration().getRecoveryRegistry(), ((RAConfiguration)this.getConfiguration()).getManagementRepository(), c.getConnector(), this.kernel.getMBeanServer(), ons, cl, c.getLog());
            return rAActivatorDeployment;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (DeployException cde) {
            throw new com.github.fungal.spi.deployers.DeployException(cde.getMessage(), cde.getCause());
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    protected boolean requireExplicitJndiBindings() {
        return false;
    }

    protected boolean checkActivation(Connector cmd, Activation activation) {
        int aos;
        if (cmd == null) {
            return false;
        }
        org.jboss.jca.common.api.metadata.spec.ResourceAdapter ra = cmd.getResourceadapter();
        if (ra == null) {
            return false;
        }
        if (activation != null) {
            int mcfs = activation.getConnectionDefinitions() != null ? activation.getConnectionDefinitions().size() : 0;
            int aos2 = activation.getAdminObjects() != null ? activation.getAdminObjects().size() : 0;
            boolean inflow = false;
            if (mcfs == 0 && ra.getOutboundResourceadapter() != null) {
                int n = mcfs = ra.getOutboundResourceadapter().getConnectionDefinitions() != null ? ra.getOutboundResourceadapter().getConnectionDefinitions().size() : 0;
            }
            if (aos2 == 0) {
                int n = aos2 = ra.getAdminObjects() != null ? ra.getAdminObjects().size() : 0;
            }
            if (ra.getInboundResourceadapter() != null && ra.getInboundResourceadapter().getMessageadapter() != null && ra.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && ra.getInboundResourceadapter().getMessageadapter().getMessagelisteners().size() > 0) {
                inflow = true;
            }
            return mcfs >= 1 || aos2 >= 1 || inflow;
        }
        int mcfs = 0;
        int n = aos = ra.getAdminObjects() != null ? ra.getAdminObjects().size() : 0;
        if (ra.getOutboundResourceadapter() != null) {
            mcfs = ra.getOutboundResourceadapter().getConnectionDefinitions() != null ? ra.getOutboundResourceadapter().getConnectionDefinitions().size() : 0;
        }
        return mcfs <= 1 && aos <= 1;
    }
}

