/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.naming.ExplicitJndiStrategy;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.logging.Logger;

public class DsXmlDeployment
implements Deployment {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)DsXmlDeployment.class.getName());
    private URL deployment;
    private String deploymentName;
    private Object[] cfs;
    private String[] jndis;
    private ConnectionManager[] cms;
    private XAResourceRecovery[] recoveryModules;
    private XAResourceRecoveryRegistry recoveryRegistry;
    private DataSource[] dataSources;
    private ManagementRepository managementRepository;
    private List<ObjectName> objectNames;
    private MBeanServer mbeanServer;
    private ClassLoader cl;

    public DsXmlDeployment(URL deployment, String deploymentName, Object[] cfs, String[] jndis, ConnectionManager[] cms, XAResourceRecovery[] recoveryModules, XAResourceRecoveryRegistry recoveryRegistry, DataSource[] dataSources, ManagementRepository managementRepository, List<ObjectName> onames, MBeanServer mbeanServer, ClassLoader cl) {
        this.deployment = deployment;
        this.deploymentName = deploymentName;
        this.cfs = cfs;
        this.jndis = jndis;
        this.cms = cms;
        this.recoveryModules = recoveryModules;
        this.recoveryRegistry = recoveryRegistry;
        this.dataSources = dataSources;
        this.managementRepository = managementRepository;
        this.objectNames = onames;
        this.mbeanServer = mbeanServer;
        this.cl = cl;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    /*
     * WARNING - void declaration
     */
    public void stop() {
        log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
        if (this.objectNames != null && this.mbeanServer != null) {
            for (ObjectName on : this.objectNames) {
                try {
                    this.mbeanServer.unregisterMBean(on);
                }
                catch (Throwable t) {
                    log.warn((Object)"Exception during JMX unregistering", t);
                }
            }
        }
        if (this.dataSources != null && this.managementRepository != null) {
            for (DataSource dataSource : this.dataSources) {
                this.managementRepository.getDataSources().remove(dataSource);
            }
        }
        if (this.recoveryModules != null && this.recoveryRegistry != null) {
            for (DataSource dataSource : this.recoveryModules) {
                if (dataSource == null) continue;
                this.recoveryRegistry.removeXAResourceRecovery((XAResourceRecovery)dataSource);
            }
        }
        if (this.cms != null) {
            for (DataSource dataSource : this.cms) {
                dataSource.shutdown();
            }
        }
        if (this.cfs != null) {
            ExplicitJndiStrategy jndiStrategy = new ExplicitJndiStrategy();
            try {
                void var4_19;
                jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs, this.jndis);
                String[] arr$ = this.jndis;
                int len$ = arr$.length;
                boolean bl = false;
                while (var4_19 < len$) {
                    String jndi = arr$[var4_19];
                    log.infof("Unbound data source at: %s", (Object)jndi);
                    ++var4_19;
                }
            }
            catch (Throwable t) {
                log.warn((Object)"Exception during JNDI unbinding", t);
            }
        }
    }

    public void destroy() {
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

